/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.ComptesLienPrivilege;
import com.notrecontinent.webapi.entities.Lienprivilege;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.PointsLienPrivilege;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ComptesLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.LienprivilegeRepository;
import com.notrecontinent.webapi.repositories.PointLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.SmsService;
import com.notrecontinent.webapi.services.WhatsappService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MissionService {
    @Autowired
    private LienprivilegeRepository lienprivilegeRepository;
    @Autowired
    private ComptesLienPrivilegeRepository comptesLienPrivilegeRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    private SmsService smsService;
    @Autowired
    private MailService mailService;
    @Autowired
    private WhatsappService whatsappService;
    @Autowired
    private PointLienPrivilegeRepository pointLienPrivilegeRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Value(value="${parametre.lien.privilege}")
    private Long param;

    @Transactional
    @Scheduled(cron="10 27 9 * * *", zone="GMT")
    public void envoyerLiensPrivileges1() {
        List missions = this.lienprivilegeRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!missions.isEmpty()) {
            Date currentdate = new Date();
            ArrayList<Lienprivilege> missions2 = new ArrayList<Lienprivilege>();
            for (Lienprivilege m2 : missions) {
                if ((currentdate.getTime() - m2.getDateCreation().getTime()) / 3600000L < 24L) continue;
                missions2.add(m2);
            }
            if (!missions2.isEmpty()) {
                List missionsparSMS = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("sms")).collect(Collectors.toList());
                List missionsparEmail = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("email")).collect(Collectors.toList());
                List missionsparWhatsapp = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("whatsapp")).collect(Collectors.toList());
                ArrayList missionList = new ArrayList();
                if (!missionsparSMS.isEmpty()) {
                    missionList.addAll(this.smsService.EnvoyerLiensPrivileges(missionsparSMS));
                }
                if (!missionsparEmail.isEmpty()) {
                    missionList.addAll(this.mailService.EnvoyerLiensPrivileges(missionsparEmail));
                }
                if (!missionsparWhatsapp.isEmpty()) {
                    missionList.addAll(this.whatsappService.EnvoyerLiensPrivileges(missionsparWhatsapp));
                }
                this.lienprivilegeRepository.saveAll(missionList);
            }
        }
    }

    @Transactional
    @Scheduled(cron="10 14 18 * * *", zone="GMT")
    public void envoyerLiensPrivileges2() {
        List missions = this.lienprivilegeRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!missions.isEmpty()) {
            Date currentdate = new Date();
            ArrayList<Lienprivilege> missions2 = new ArrayList<Lienprivilege>();
            for (Lienprivilege m2 : missions) {
                if ((currentdate.getTime() - m2.getDateCreation().getTime()) / 3600000L < 24L) continue;
                missions2.add(m2);
            }
            if (!missions2.isEmpty()) {
                List missionsparSMS = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("sms")).collect(Collectors.toList());
                List missionsparEmail = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("email")).collect(Collectors.toList());
                List missionsparWhatsapp = missions2.stream().filter(m -> m.getEstenvoyerpar().equals("whatsapp")).collect(Collectors.toList());
                ArrayList missionList = new ArrayList();
                if (!missionsparSMS.isEmpty()) {
                    missionList.addAll(this.smsService.EnvoyerLiensPrivileges(missionsparSMS));
                }
                if (!missionsparEmail.isEmpty()) {
                    missionList.addAll(this.mailService.EnvoyerLiensPrivileges(missionsparEmail));
                }
                if (!missionsparWhatsapp.isEmpty()) {
                    missionList.addAll(this.whatsappService.EnvoyerLiensPrivileges(missionsparWhatsapp));
                }
                this.lienprivilegeRepository.saveAll(missionList);
            }
        }
    }

    @Transactional
    public String GenererLienPrivilege(Lienprivilege lienprivilege) {
        Lienprivilege lienprivilege1 = this.lienprivilegeRepository.findByAuteurid(lienprivilege.getAuteurid());
        if (lienprivilege1 != null) {
            return "en commission de validation";
        }
        Lienprivilege mission1 = this.lienprivilegeRepository.findByParametre(this.param);
        if (mission1 != null) {
            Lienprivilege mission2 = this.lienprivilegeRepository.findFirstByOrderByIdDesc();
            this.param = mission2.getParametre() + 1L;
        }
        String lienPrivilege = "https://lk.clickofafrica.com/?p=dev/";
        lienPrivilege = lienPrivilege + this.param;
        lienprivilege.setLienprivilege(lienPrivilege);
        lienprivilege.setParametre(this.param);
        this.lienprivilegeRepository.save((Object)lienprivilege);
        return "lien privil\u00e8ge g\u00e9n\u00e9r\u00e9";
    }

    public void SaveComptelienPrivilege(Long paramlien, Long idcompte, String usernamecompte) {
        Lienprivilege lienprivilege = this.lienprivilegeRepository.findByParametre(paramlien);
        if (lienprivilege != null) {
            ComptesLienPrivilege comptesLienPrivilege = new ComptesLienPrivilege();
            comptesLienPrivilege.setIdcomptecreer(idcompte);
            comptesLienPrivilege.setIdcompteproplien(lienprivilege.getAuteurid());
            comptesLienPrivilege.setUsernamecomptecreer(usernamecompte);
            comptesLienPrivilege.setUsernamecompteproplien(lienprivilege.getCompte());
            comptesLienPrivilege.setLienprivilege(lienprivilege.getLienprivilege());
            comptesLienPrivilege.setEsttraiter(Boolean.valueOf(false));
            this.comptesLienPrivilegeRepository.save((Object)comptesLienPrivilege);
        }
    }

    @Transactional
    public ResponseEntity<Lienprivilege> getlienprivilegebyauteurid(Long auteurid) throws JsonProcessingException {
        Lienprivilege lienprivilege = this.lienprivilegeRepository.findByAuteuridAndEstenvoyer(auteurid, Boolean.valueOf(true));
        if (lienprivilege == null) {
            lienprivilege = new Lienprivilege();
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)lienprivilege);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)lienprivilege);
    }

    @Transactional
    @Scheduled(cron="11 11 18 * * *", zone="GMT")
    public void AffecterPoints() {
        List auteurs = this.auteurRepository.findByLienprivilegetraiterAndParamlienprivilegeIsNotNull(Boolean.valueOf(false));
        if (!auteurs.isEmpty()) {
            LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
            Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            String mois = dateFormat.format(currentdate);
            for (Auteur auteur : auteurs) {
                Long idauteur;
                Auteur auteur1;
                Lienprivilege lienprivilege = this.lienprivilegeRepository.findByParametre(auteur.getParamlienprivilege());
                if (lienprivilege != null && (auteur1 = (Auteur)this.auteurRepository.findById((Object)(idauteur = lienprivilege.getAuteurid())).get()).getMonetisation() != null && auteur1.getMonetisation().equals("Oui")) {
                    PointsLienPrivilege pointsLienPrivilege = this.pointLienPrivilegeRepository.findByAuteuridAndMois(idauteur, mois);
                    if (pointsLienPrivilege == null) {
                        PointsLienPrivilege p = new PointsLienPrivilege();
                        p.setAuteurid(idauteur);
                        p.setMois(mois);
                        p.setNbPointsComptesCreer(Long.valueOf(10L));
                        p.setNbComptesCreer(Long.valueOf(1L));
                        p.setRolecompte(auteur1.getRole());
                        this.pointLienPrivilegeRepository.save((Object)p);
                    } else {
                        pointsLienPrivilege.setNbComptesCreer(Long.valueOf(pointsLienPrivilege.getNbComptesCreer() + 1L));
                        pointsLienPrivilege.setNbPointsComptesCreer(Long.valueOf(pointsLienPrivilege.getNbPointsComptesCreer() + 10L));
                        pointsLienPrivilege.setRolecompte(auteur1.getRole());
                        this.pointLienPrivilegeRepository.save((Object)pointsLienPrivilege);
                    }
                    if (auteur1.getRole().equals("ami")) {
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, auteur1.getId());
                        if (pointsAmi == null) {
                            PointsAmi p = new PointsAmi();
                            p.setAmiId(auteur1.getId());
                            p.setNbMissions(Long.valueOf(1L));
                            p.setNbPointsMissions(Long.valueOf(10L));
                            p.setNbPointsMois(Long.valueOf(10L));
                            p.setNbPointsRecommandations(Long.valueOf(0L));
                            p.setNbRecommandations(Long.valueOf(0L));
                            p.setNbPointsArticlesLus(Long.valueOf(0L));
                            p.setNbArticlesLus(Long.valueOf(0L));
                            p.setMois(mois);
                            this.pointsAmiRepository.save((Object)p);
                        } else {
                            pointsAmi.setNbMissions(Long.valueOf(pointsAmi.getNbMissions() + 1L));
                            pointsAmi.setNbPointsMissions(Long.valueOf(pointsAmi.getNbPointsMissions() + 10L));
                            pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 10L));
                            this.pointsAmiRepository.save((Object)pointsAmi);
                        }
                    }
                    auteur1.setTotalPointsCumules(Long.valueOf(auteur1.getTotalPointsCumules() + 10L));
                    this.auteurRepository.save((Object)auteur1);
                }
                auteur.setLienprivilegetraiter(Boolean.valueOf(true));
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
    }

    @Transactional
    @Scheduled(cron="30 5 4 1 * *", zone="GMT")
    public void RecalculerPointsmissions() {
        List auteurs;
        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime datelastmonth = now.minusMonths(1L);
        Date dateelastmonth = Date.from(datelastmonth.atZone(ZoneId.of("GMT")).toInstant());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
        String lastmois = dateFormat.format(dateelastmonth);
        List auteursList = this.auteurRepository.findByLienprivilegetraiterAndParamlienprivilegeIsNotNull(Boolean.valueOf(true));
        if (!auteursList.isEmpty() && !(auteurs = auteursList.stream().filter(a -> dateFormat.format(a.getDateCreation()).equals(lastmois)).collect(Collectors.toList())).isEmpty()) {
            HashSet<Long> paramliens = new HashSet<Long>();
            for (Auteur auteur : auteurs) {
                paramliens.add(auteur.getParamlienprivilege());
            }
            for (Long paramlien : paramliens) {
                Auteur auteur1;
                Long nbcomptes = auteurs.stream().filter(a -> Objects.equals(a.getParamlienprivilege(), paramlien)).count();
                Lienprivilege lienprivilege = this.lienprivilegeRepository.findByParametre(paramlien);
                if (lienprivilege == null || (auteur1 = (Auteur)this.auteurRepository.findById((Object)lienprivilege.getAuteurid()).get()).getMonetisation() == null || !auteur1.getMonetisation().equals("Oui")) continue;
                PointsLienPrivilege pointsLienPrivilege = this.pointLienPrivilegeRepository.findByAuteuridAndMois(lienprivilege.getAuteurid(), lastmois);
                if (pointsLienPrivilege != null) {
                    pointsLienPrivilege.setNbComptesCreer(nbcomptes);
                    pointsLienPrivilege.setNbPointsComptesCreer(Long.valueOf(nbcomptes * 10L));
                    pointsLienPrivilege.setRolecompte(auteur1.getRole());
                    this.pointLienPrivilegeRepository.save((Object)pointsLienPrivilege);
                } else {
                    PointsLienPrivilege p = new PointsLienPrivilege();
                    p.setNbPointsComptesCreer(Long.valueOf(nbcomptes * 10L));
                    p.setNbComptesCreer(nbcomptes);
                    p.setAuteurid(lienprivilege.getAuteurid());
                    p.setRolecompte(auteur1.getRole());
                    p.setMois(lastmois);
                    this.pointLienPrivilegeRepository.save((Object)p);
                }
                if (!auteur1.getRole().equals("ami")) continue;
                PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(lastmois, auteur1.getId());
                if (pointsAmi == null) {
                    PointsAmi p = new PointsAmi();
                    p.setAmiId(auteur1.getId());
                    p.setNbMissions(nbcomptes);
                    p.setNbPointsMissions(Long.valueOf(10L * nbcomptes));
                    p.setNbPointsMois(Long.valueOf(10L * nbcomptes));
                    p.setNbPointsRecommandations(Long.valueOf(0L));
                    p.setNbRecommandations(Long.valueOf(0L));
                    p.setNbPointsArticlesLus(Long.valueOf(0L));
                    p.setNbArticlesLus(Long.valueOf(0L));
                    p.setMois(lastmois);
                    this.pointsAmiRepository.save((Object)p);
                    continue;
                }
                pointsAmi.setNbMissions(nbcomptes);
                pointsAmi.setNbPointsMissions(Long.valueOf(nbcomptes * 10L));
                pointsAmi.setNbPointsMois(Long.valueOf(nbcomptes + 10L));
                this.pointsAmiRepository.save((Object)pointsAmi);
            }
        }
    }

    @Transactional
    public void Affecterlespoints() {
        List comptesLienPrivilegeList = this.comptesLienPrivilegeRepository.findByEsttraiter(Boolean.valueOf(false));
        if (!comptesLienPrivilegeList.isEmpty()) {
            LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
            Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            String mois = dateFormat.format(currentdate);
            HashSet<Long> idsauteur = new HashSet<Long>();
            for (ComptesLienPrivilege c2 : comptesLienPrivilegeList) {
                idsauteur.add(c2.getIdcompteproplien());
            }
            for (Long id : idsauteur) {
                Long nbcomptes = comptesLienPrivilegeList.stream().filter(c -> Objects.equals(c.getIdcompteproplien(), id)).count();
                Auteur auteur = (Auteur)this.auteurRepository.findById((Object)id).get();
                if (auteur.getMonetisation() == null || !auteur.getMonetisation().equals("Oui")) continue;
                PointsLienPrivilege pointsLienPrivilege = this.pointLienPrivilegeRepository.findByAuteuridAndMois(id, mois);
                if (pointsLienPrivilege == null) {
                    PointsLienPrivilege p = new PointsLienPrivilege();
                    p.setAuteurid(id);
                    p.setMois(mois);
                    p.setNbPointsComptesCreer(Long.valueOf(10L * nbcomptes));
                    p.setNbComptesCreer(nbcomptes);
                    p.setRolecompte(auteur.getRole());
                    this.pointLienPrivilegeRepository.save((Object)p);
                } else {
                    pointsLienPrivilege.setNbComptesCreer(Long.valueOf(pointsLienPrivilege.getNbComptesCreer() + nbcomptes));
                    pointsLienPrivilege.setNbPointsComptesCreer(Long.valueOf(pointsLienPrivilege.getNbPointsComptesCreer() + 10L * nbcomptes));
                    pointsLienPrivilege.setRolecompte(auteur.getRole());
                    this.pointLienPrivilegeRepository.save((Object)pointsLienPrivilege);
                }
                if (auteur.getRole().equals("ami")) {
                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, id);
                    if (pointsAmi != null) {
                        pointsAmi.setNbMissions(Long.valueOf(pointsAmi.getNbMissions() + nbcomptes));
                        pointsAmi.setNbPointsMissions(Long.valueOf(pointsAmi.getNbPointsMissions() + 10L * nbcomptes));
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 10L * nbcomptes));
                        this.pointsAmiRepository.save((Object)pointsAmi);
                    } else {
                        PointsAmi p = new PointsAmi();
                        p.setAmiId(id);
                        p.setNbMissions(nbcomptes);
                        p.setNbPointsMissions(Long.valueOf(10L * nbcomptes));
                        p.setNbPointsMois(Long.valueOf(10L * nbcomptes));
                        p.setNbPointsArticlesLus(Long.valueOf(0L));
                        p.setNbArticlesLus(Long.valueOf(0L));
                        p.setNbRecommandations(Long.valueOf(0L));
                        p.setNbPointsRecommandations(Long.valueOf(0L));
                        p.setMois(mois);
                        this.pointsAmiRepository.save((Object)p);
                    }
                }
                auteur.setTotalPointsCumules(Long.valueOf(auteur.getTotalPointsCumules() + 10L * nbcomptes));
                this.auteurRepository.save((Object)auteur);
                for (ComptesLienPrivilege comptesLienPrivilege : comptesLienPrivilegeList) {
                    if (!Objects.equals(comptesLienPrivilege.getIdcompteproplien(), id)) continue;
                    comptesLienPrivilege.setEsttraiter(Boolean.valueOf(true));
                }
            }
            this.comptesLienPrivilegeRepository.saveAll((Iterable)comptesLienPrivilegeList);
        }
    }

    @Transactional
    public void RecalculerLesPointsmissions() {
        List comptesLienPrivilegeList;
        LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime datelastmonth = now.minusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0);
        Date dateelastmonth = Date.from(datelastmonth.atZone(ZoneId.of("GMT")).toInstant());
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
        String mois = dateFormat.format(dateelastmonth);
        List comptesLienPrivilegeList1 = this.comptesLienPrivilegeRepository.findalloflastmonth(dateelastmonth);
        if (!comptesLienPrivilegeList1.isEmpty() && !(comptesLienPrivilegeList = comptesLienPrivilegeList1.stream().filter(c -> dateFormat.format(c.getDateCreation()).equals(mois)).collect(Collectors.toList())).isEmpty()) {
            HashSet<Long> idsauteur = new HashSet<Long>();
            for (ComptesLienPrivilege c2 : comptesLienPrivilegeList) {
                idsauteur.add(c2.getIdcompteproplien());
            }
            for (Long id : idsauteur) {
                Long nbcomptes = comptesLienPrivilegeList.stream().filter(c -> Objects.equals(c.getIdcompteproplien(), id)).count();
                Auteur auteur = (Auteur)this.auteurRepository.findById((Object)id).get();
                if (auteur.getMonetisation() == null || !auteur.getMonetisation().equals("Oui")) continue;
                PointsLienPrivilege pointsLienPrivilege = this.pointLienPrivilegeRepository.findByAuteuridAndMois(id, mois);
                if (pointsLienPrivilege == null) {
                    PointsLienPrivilege p = new PointsLienPrivilege();
                    p.setAuteurid(id);
                    p.setMois(mois);
                    p.setNbPointsComptesCreer(Long.valueOf(10L * nbcomptes));
                    p.setNbComptesCreer(nbcomptes);
                    p.setRolecompte(auteur.getRole());
                    this.pointLienPrivilegeRepository.save((Object)p);
                } else {
                    pointsLienPrivilege.setNbComptesCreer(nbcomptes);
                    pointsLienPrivilege.setNbPointsComptesCreer(Long.valueOf(10L * nbcomptes));
                    pointsLienPrivilege.setRolecompte(auteur.getRole());
                    this.pointLienPrivilegeRepository.save((Object)pointsLienPrivilege);
                }
                if (auteur.getRole().equals("ami")) {
                    PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, id);
                    if (pointsAmi != null) {
                        pointsAmi.setNbMissions(nbcomptes);
                        pointsAmi.setNbPointsMissions(Long.valueOf(10L * nbcomptes));
                        pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsArticlesLus() + pointsAmi.getNbPointsRecommandations() + 10L * nbcomptes));
                        this.pointsAmiRepository.save((Object)pointsAmi);
                    } else {
                        PointsAmi p = new PointsAmi();
                        p.setAmiId(id);
                        p.setNbMissions(nbcomptes);
                        p.setNbPointsMissions(Long.valueOf(10L * nbcomptes));
                        p.setNbPointsMois(Long.valueOf(10L * nbcomptes));
                        p.setNbPointsArticlesLus(Long.valueOf(0L));
                        p.setNbArticlesLus(Long.valueOf(0L));
                        p.setNbRecommandations(Long.valueOf(0L));
                        p.setNbPointsRecommandations(Long.valueOf(0L));
                        p.setMois(mois);
                        this.pointsAmiRepository.save((Object)p);
                    }
                }
                for (ComptesLienPrivilege comptesLienPrivilege : comptesLienPrivilegeList) {
                    if (!Objects.equals(comptesLienPrivilege.getIdcompteproplien(), id)) continue;
                    comptesLienPrivilege.setEsttraiter(Boolean.valueOf(true));
                }
            }
        }
    }
}

