/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.RecommandationAuteurDTO;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.mapstruct.RecommandationMapper;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecommandationService {
    @Value(value="${parametre.lien.recommandation}")
    private Long param;
    @Autowired
    private RecommandationMapper recommandationMapper;
    @Autowired
    private RecommandationRepository recommandationRepository;

    @Transactional
    public List<Recommandation> getAllRecommandations() {
        return this.recommandationRepository.findAll();
    }

    public ResponseEntity<List<RecommandationAuteurDTO>> getAllRecommandationsByAmiId(Long id) throws JsonProcessingException {
        List recommandations = this.recommandationRepository.findByAuteuridOrderByEstcliquerAscDateCreationDesc(id);
        if (!recommandations.isEmpty()) {
            List recommandationAuteurDTOS = this.recommandationMapper.RecommandationsToRecommandateurAuteurDTO(recommandations);
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString((Object)recommandationAuteurDTOS);
            long contentLength = jsonString.getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAuteurDTOS);
        }
        return null;
    }

    @Transactional
    public Recommandation AddRecommandation(Recommandation recommandation) {
        Recommandation recommandation1 = this.recommandationRepository.findByParametre(this.param);
        if (recommandation1 != null) {
            Recommandation recommandation2 = this.recommandationRepository.findFirstByOrderByIdDesc();
            this.param = recommandation2.getParametre() + 1L;
        }
        recommandation.setParametre(this.param);
        recommandation.setEstcliquer(Boolean.valueOf(false));
        recommandation.setCompte("toplayene95@gmail.com");
        recommandation.setAuteurid(Long.valueOf(11L));
        String lienrecommandation = "http://localhost:4300/";
        lienrecommandation = lienrecommandation + recommandation.getLienarticle().split("notrecontinent.com/")[1];
        lienrecommandation = lienrecommandation + recommandation.getParametre();
        recommandation.setLienrecommandation(lienrecommandation);
        Recommandation recommandation2 = (Recommandation)this.recommandationRepository.save((Object)recommandation);
        this.param = this.param + 1L;
        return recommandation2;
    }

    @Transactional
    public String UpdateStatusRecommandation(Long parametre) {
        Recommandation recommandation = this.recommandationRepository.findByParametre(parametre);
        if (recommandation != null) {
            if (!recommandation.getEstcliquer().booleanValue()) {
                recommandation.setEstcliquer(Boolean.valueOf(true));
                this.recommandationRepository.save((Object)recommandation);
            }
            return "lu";
        }
        return "non lu";
    }
}

