/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.ArticlesAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurAdminDto;
import com.notrecontinent.webapi.LesDTOs.AuteurPwdDTO;
import com.notrecontinent.webapi.LesDTOs.NotificationSmsStatus;
import com.notrecontinent.webapi.LesDTOs.RecommandationAdminDTO;
import com.notrecontinent.webapi.LesDTOs.StatistiquesArticle;
import com.notrecontinent.webapi.dto.ArticleWpDesactiver;
import com.notrecontinent.webapi.dto.DashbordStats;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Bugs;
import com.notrecontinent.webapi.entities.CompteASupprimer;
import com.notrecontinent.webapi.entities.Connexion;
import com.notrecontinent.webapi.entities.ModePaiement;
import com.notrecontinent.webapi.entities.MonCompte;
import com.notrecontinent.webapi.entities.PaiementAdmin;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.Transaction;
import com.notrecontinent.webapi.enumeration.SubdomainsPaysEnum;
import com.notrecontinent.webapi.mapstruct.AuteurMapper;
import com.notrecontinent.webapi.mapstruct.RecommandationMapper;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.CompteASupprimerRepository;
import com.notrecontinent.webapi.repositories.ConnexionRepository;
import com.notrecontinent.webapi.repositories.ModePaiementRepository;
import com.notrecontinent.webapi.repositories.MonCompteRepository;
import com.notrecontinent.webapi.repositories.PaiementAdminRepository;
import com.notrecontinent.webapi.repositories.PaiementRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.PointsContributeurRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.repositories.StatistiqueRepository;
import com.notrecontinent.webapi.repositories.TransactionRepository;
import com.notrecontinent.webapi.response.UserInfoResponse;
import com.notrecontinent.webapi.security.jwt.JwtUtils;
import com.notrecontinent.webapi.security.services.UserDetailsServiceImpl;
import com.notrecontinent.webapi.services.ArticleService;
import com.notrecontinent.webapi.services.BugService;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.PhotoService;
import com.notrecontinent.webapi.services.SmsService;
import java.io.IOException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AdminService {
    @Value(value="${parametre.ref.interne}")
    private Long ref;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private ConnexionRepository connexionRepository;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper mapper;
    @Autowired
    private BugService bugService;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private ArticleService articleService;
    @Autowired
    private AuteurMapper auteurMapper;
    @Autowired
    private UserDetailsServiceImpl userDetailsService;
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private CompteASupprimerRepository compteASupprimerRepository;
    @Autowired
    private RecommandationMapper recommandationMapper;
    @Autowired
    private PaiementRepository paiementRepository;
    @Autowired
    private ModePaiementRepository modePaiementRepository;
    @Autowired
    private StatistiqueRepository statistiqueRepository;
    @Autowired
    private PointsContributeurRepository pointsContributeurRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private MonCompteRepository monCompteRepository;
    @Autowired
    private TransactionRepository transactionRepository;
    @Autowired
    private PaiementAdminRepository paiementAdminRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    JwtUtils jwtUtils;
    String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    public ResponseEntity<List<Connexion>> getAllConnexion() throws JsonProcessingException {
        List connexions = this.connexionRepository.findByOrderByDateConnexionDesc();
        long contentLength = this.mapper.writeValueAsString((Object)connexions).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)connexions);
    }

    @Transactional
    public String Deconnexion(Long idconnexion) throws ParseException {
        Connexion connexion = (Connexion)this.connexionRepository.findById((Object)idconnexion).get();
        connexion.setFinSession(new Date());
        this.connexionRepository.save((Object)connexion);
        return "D\u00e9connexion r\u00e9ussie";
    }

    @Transactional
    public ResponseEntity<List<ArticlesAdminDto>> getAllArticles() throws IOException {
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add("Validation en cours");
        statusList.add("Valid\u00e9 (en ligne)");
        statusList.add("Rejet\u00e9");
        List articles = this.articleRepository.findByStatusInOrderByDateCreationDesc(statusList);
        ArrayList<ArticlesAdminDto> articlesAdmin = new ArrayList<ArticlesAdminDto>();
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                ArticlesAdminDto articleAdmin = new ArticlesAdminDto();
                articleAdmin.setArticleid(article.getId());
                articleAdmin.setLien(article.getLink());
                articleAdmin.setTitre(article.getTitre());
                articleAdmin.setCategorie(article.getCategorie());
                articleAdmin.setDatecreation(article.getDateCreation());
                articleAdmin.setStatus(article.getStatus());
                articleAdmin.setChecked(Boolean.valueOf(false));
                articleAdmin.setAuteurname(((Auteur)this.auteurRepository.findById((Object)article.getAuteurID()).get()).getName());
                articlesAdmin.add(articleAdmin);
            }
        }
        long contentLength = this.mapper.writeValueAsString(articlesAdmin).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(articlesAdmin);
    }

    @Transactional
    public String DeactivateArticle(String id) {
        Optional article = this.articleRepository.findById((Object)Long.valueOf(id));
        if (article.isPresent()) {
            Article article1 = (Article)article.get();
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            authHeader = article1.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
            headers.set("Authorization", authHeader);
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            article1.setLastStatus(article1.getStatus());
            article1.setAdesactiver(Boolean.valueOf(true));
            article1.setStatus("Rejet\u00e9");
            article1.setDatemodification(new Date());
            this.articleRepository.save((Object)article1);
        }
        return "Article d\u00e9sactiv\u00e9";
    }

    @Transactional
    public String DeactivateArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            }
            for (Article article : articles) {
                article.setLastStatus(article.getStatus());
                article.setAdesactiver(Boolean.valueOf(true));
                article.setStatus("Rejet\u00e9");
                article.setDatemodification(new Date());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
        return "Articles d\u00e9sactiv\u00e9s";
    }

    @Transactional
    public String ReactivateArticle(String id) {
        Optional article = this.articleRepository.findById((Object)Long.valueOf(id));
        if (article.isPresent()) {
            Article article1 = (Article)article.get();
            article1.setAreactiver(Boolean.valueOf(true));
            article1.setDatemodification(new Date());
            article1.setStatus(article1.getLastStatus());
            this.articleRepository.save((Object)article1);
        }
        return "Article r\u00e9activ\u00e9";
    }

    @Transactional
    public String ReactivateArticles(List<Long> ids) {
        List articles = this.articleRepository.findAllById(ids);
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                article.setAreactiver(Boolean.valueOf(true));
                article.setStatus(article.getLastStatus());
                article.setDatemodification(new Date());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
        return "Articles r\u00e9activ\u00e9s";
    }

    @Transactional
    public void DeactivateArticlesInWP() {
        List articles = this.articleRepository.findByStatusAndAdesactiver("Rejet\u00e9", Boolean.valueOf(true));
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                articleWpDesactiver = new ArticleWpDesactiver();
                articleWpDesactiver.setStatus("pending");
                HttpEntity requestEntity = new HttpEntity((Object)articleWpDesactiver, (MultiValueMap)headers);
                this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + article.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                article.setAdesactiver(Boolean.valueOf(false));
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
    }

    @Transactional
    public void ReactivateArticlesInWP() {
        List articles = this.articleRepository.findByStatusAndAreactiver("Rejet\u00e9", Boolean.valueOf(true));
        if (!articles.isEmpty()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            ArticleWpDesactiver articleWpDesactiver = new ArticleWpDesactiver();
            for (Article article : articles) {
                headers = new HttpHeaders();
                authHeader = article.getSousdomaine().equals(SubdomainsPaysEnum.SN.getSubdomain()) ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                headers.set("Authorization", authHeader);
                articleWpDesactiver = new ArticleWpDesactiver();
                switch (article.getLastStatus()) {
                    case "Validation en cours": {
                        articleWpDesactiver.setStatus("draft");
                        break;
                    }
                    case "Valid\u00e9 (en ligne)": {
                        articleWpDesactiver.setStatus("publish");
                    }
                }
                HttpEntity requestEntity = new HttpEntity((Object)articleWpDesactiver, (MultiValueMap)headers);
                this.restTemplate.exchange(article.getSousdomaine() + "/wp-json/wp/v2/posts/" + article.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                article.setAreactiver(Boolean.valueOf(false));
                article.setStatus(article.getLastStatus());
            }
            this.articleRepository.saveAll((Iterable)articles);
        }
    }

    public ResponseEntity<List<AuteurAdminDto>> getAllAuteur() throws JsonProcessingException {
        List auteurs = this.auteurRepository.findByOrderByDateCreationDesc();
        List auteurAdminDtos = new ArrayList();
        if (!auteurs.isEmpty()) {
            auteurAdminDtos = this.auteurMapper.AuteursToAuteurAdminDtos(auteurs);
        }
        long contentLength = this.mapper.writeValueAsString(auteurAdminDtos).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(auteurAdminDtos);
    }

    public String generateRandomString(int length) {
        String SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".length());
            char randomChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".charAt(randomIndex);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    @Transactional
    public Auteur CreateAuteur(Auteur auteur) {
        Boolean b = this.auteurRepository.existsByUsernameAndBloquer(auteur.getUsername(), Boolean.valueOf(false));
        if (b.booleanValue()) {
            return null;
        }
        auteur.setEmail(auteur.getUsername() + "@notrecontinent.com");
        String pwd = this.bCryptPasswordEncoder.encode((CharSequence)auteur.getPassword());
        auteur.setPassword(pwd);
        auteur.setPays("S\u00e9n\u00e9gal");
        auteur.setCreerpar("t\u00e9l\u00e9phone");
        auteur.setRole("ami");
        auteur.setTelephone(auteur.getUsername());
        auteur.setCountrycodetelephone("SN");
        auteur.setCountrycodewhatsapp("SN");
        auteur.setBloquer(Boolean.valueOf(false));
        auteur.setMailenvoyer(Boolean.valueOf(false));
        String pwdcontrol = this.generateRandomString(15);
        auteur.setPasswordcontrole(pwdcontrol);
        auteur.setPasswordcontroleEncrypted(this.bCryptPasswordEncoder.encode((CharSequence)pwdcontrol));
        return (Auteur)this.auteurRepository.save((Object)auteur);
    }

    @Transactional
    public String UpdatePasswordAuteur(String id, String newpwd) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            String pwd = this.bCryptPasswordEncoder.encode((CharSequence)newpwd);
            auteur1.setPassword(pwd);
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Mot de passe modifi\u00e9";
    }

    @Transactional
    public String Updatemonetisation(Long id, String etat) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            ((Auteur)auteur.get()).setMonetisation(etat);
            Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
            MonCompte monCompte = this.monCompteRepository.findByAuteurid(id);
            if (monCompte != null) {
                if (auteur1.getMonetisation().equals("Oui")) {
                    monCompte.setMonetisation(Boolean.valueOf(true));
                } else if (auteur1.getMonetisation().equals("Non")) {
                    monCompte.setMonetisation(Boolean.valueOf(false));
                }
                this.monCompteRepository.save((Object)monCompte);
            } else {
                MonCompte monCompte1 = new MonCompte();
                monCompte1.setAuteurid(id);
                if (auteur1.getMonetisation().equals("Oui")) {
                    monCompte1.setMonetisation(Boolean.valueOf(true));
                } else if (auteur1.getMonetisation().equals("Non")) {
                    monCompte1.setMonetisation(Boolean.valueOf(false));
                }
                this.monCompteRepository.save((Object)monCompte1);
            }
        }
        return "Mon\u00e9tisation mise \u00e0 jour";
    }

    @Transactional
    public String BloquerAuteur(String id) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setBloquer(Boolean.valueOf(true));
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Auteur bloqu\u00e9";
    }

    @Transactional
    public String ReactiverAuteur(String id) {
        Optional auteur = this.auteurRepository.findById((Object)Long.valueOf(id));
        if (auteur.isPresent()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setBloquer(Boolean.valueOf(false));
            auteur1.setDateModification(new Date());
            this.auteurRepository.save((Object)auteur1);
        }
        return "Auteur r\u00e9activ\u00e9";
    }

    @Transactional
    public String BloquerAuteurs(List<Long> ids) {
        List auteurs = this.auteurRepository.findAllById(ids);
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                auteur.setBloquer(Boolean.valueOf(true));
                auteur.setDateModification(new Date());
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
        return "Auteurs bloqu\u00e9s";
    }

    @Transactional
    public String ReactiverAuteurs(List<Long> ids) {
        List auteurs = this.auteurRepository.findAllById(ids);
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                auteur.setBloquer(Boolean.valueOf(false));
                auteur.setDateModification(new Date());
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
        return "Auteurs r\u00e9activ\u00e9s";
    }

    @Transactional
    public String deleteCompte(Long id) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent() && !this.compteASupprimerRepository.existsByCompteID(id).booleanValue()) {
            Auteur auteur1 = (Auteur)auteur.get();
            auteur1.setAsupprimer(Boolean.valueOf(true));
            auteur1.setBloquer(Boolean.valueOf(true));
            CompteASupprimer compteASupprimer = new CompteASupprimer();
            compteASupprimer.setCompteID(id);
            compteASupprimer.setUsername(auteur1.getUsername());
            compteASupprimer.setAsupprimer(Boolean.valueOf(true));
            compteASupprimer.setRole(auteur1.getRole());
            this.compteASupprimerRepository.save((Object)compteASupprimer);
            this.auteurRepository.save((Object)auteur1);
        }
        return "Compte pr\u00eat \u00e0 \u00eatre supprim\u00e9";
    }

    @Transactional
    public void SupprimerAuteurWP() {
        List auteurs = this.auteurRepository.findByAsupprimer(Boolean.valueOf(true));
        if (!auteurs.isEmpty()) {
            String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
            String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";
            HttpHeaders header = new HttpHeaders();
            String authHeader = "";
            for (Auteur auteur : auteurs) {
                int statusCode;
                ResponseEntity response;
                String deleteUserUrl;
                HttpEntity requestEntity;
                CompteASupprimer compteASupprimer = this.compteASupprimerRepository.findByCompteID(auteur.getId());
                if (compteASupprimer == null) continue;
                if (auteur.getWordpressID() != null && !compteASupprimer.getStatusSNwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://sn.notrecontinent.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusSNwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusSNwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusSNwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans SN Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getMlWordpressID() != null && !compteASupprimer.getStatusMLwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ml.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getMlWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusMLwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusMLwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusMLwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans ML Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getGnWordpressID() != null && !compteASupprimer.getStatusGNwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://gn.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getGnWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusGNwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusGNwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusGNwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans GN Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getGaWordpressID() != null && !compteASupprimer.getStatusGAwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ga.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getGaWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusGAwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusGAwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusGAwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans GA Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getBjWordpressID() != null && !compteASupprimer.getStatusBJwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://bj.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getBjWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusBJwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusBJwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusBJwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans BJ Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getBfWordpressID() != null && !compteASupprimer.getStatusBFwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://bf.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getBfWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusBFwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusBFwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusBFwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans BF Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getNeWordpressID() != null && !compteASupprimer.getStatusNEwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ne.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getNeWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusNEwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusNEwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusNEwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans NE Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCiWordpressID() != null && !compteASupprimer.getStatusCIwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ci.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCiWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusCIwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusCIwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusCIwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans CI Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCdWordpressID() != null && !compteASupprimer.getStatusCDwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://cd.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCdWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusCDwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusCDwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusCDwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans CD Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCgWordpressID() != null && !compteASupprimer.getStatusCGwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://cg.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCgWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusCGwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusCGwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusCGwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans CG Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getMrWordpressID() != null && !compteASupprimer.getStatusMRwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://mr.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getMrWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusMRwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusMRwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusMRwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans MR Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getMgWordpressID() != null && !compteASupprimer.getStatusMGwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://mg.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getMgWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusMGwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusMGwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusMGwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans MG Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getTgWordpressID() != null && !compteASupprimer.getStatusTGwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://tg.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getTgWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusTGwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusTGwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusTGwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans TG Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getFrWordpressID() != null && !compteASupprimer.getStatusFRwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://fr.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getFrWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusFRwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusFRwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusFRwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans FR Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCaWordpressID() != null && !compteASupprimer.getStatusCAwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://ca.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCaWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusCAwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusCAwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusCAwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans CA Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                if (auteur.getCmWordpressID() != null && !compteASupprimer.getStatusCMwordpress().equals("compte supprim\u00e9")) {
                    authHeader = "Basic " + Base64.getEncoder().encodeToString(userPassci.getBytes());
                    header.set("Authorization", authHeader);
                    requestEntity = new HttpEntity((MultiValueMap)header);
                    deleteUserUrl = "https://cm.parlerlibrement.com/wp/v2/users/";
                    try {
                        response = this.restTemplate.exchange(deleteUserUrl + auteur.getCmWordpressID(), HttpMethod.DELETE, requestEntity, String.class, new Object[0]);
                        statusCode = response.getStatusCodeValue();
                        if (statusCode == 200) {
                            compteASupprimer.setStatusCMwordpress("compte supprim\u00e9");
                        } else if (statusCode == 404) {
                            compteASupprimer.setStatusCMwordpress("le compte n'existe pas");
                        } else if (statusCode == 500) {
                            compteASupprimer.setStatusCMwordpress("erreur interne du serveur WP");
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Suppression compte dans CM Wordpress", e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                this.compteASupprimerRepository.save((Object)compteASupprimer);
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
    }

    @Transactional
    public void SupprimerAuteursSpeakyfree() throws IOException {
        List compteASupprimers = this.compteASupprimerRepository.findByAsupprimer(Boolean.valueOf(true));
        if (!compteASupprimers.isEmpty()) {
            String CS = "compte supprim\u00e9";
            String CEP = "le compte n'existe pas";
            for (CompteASupprimer c : compteASupprimers) {
                Boolean b = !(!c.getStatusSNwordpress().equals(CS) && !c.getStatusSNwordpress().equals(CEP) || !c.getStatusGNwordpress().equals(CS) && !c.getStatusGNwordpress().equals(CEP) || !c.getStatusBFwordpress().equals(CS) && !c.getStatusBFwordpress().equals(CEP) || !c.getStatusCDwordpress().equals(CS) && !c.getStatusCDwordpress().equals(CEP) || !c.getStatusCAwordpress().equals(CS) && !c.getStatusCAwordpress().equals(CEP) || !c.getStatusBJwordpress().equals(CS) && !c.getStatusBJwordpress().equals(CEP) || !c.getStatusCGwordpress().equals(CS) && !c.getStatusCGwordpress().equals(CEP) || !c.getStatusCIwordpress().equals(CS) && !c.getStatusCIwordpress().equals(CEP) || !c.getStatusCMwordpress().equals(CS) && !c.getStatusCMwordpress().equals(CEP) || !c.getStatusFRwordpress().equals(CS) && !c.getStatusFRwordpress().equals(CEP) || !c.getStatusGAwordpress().equals(CS) && !c.getStatusGAwordpress().equals(CEP) || !c.getStatusMGwordpress().equals(CS) && !c.getStatusMGwordpress().equals(CEP) || !c.getStatusMLwordpress().equals(CS) && !c.getStatusMLwordpress().equals(CEP) || !c.getStatusMRwordpress().equals(CS) && !c.getStatusMRwordpress().equals(CEP) || !c.getStatusNEwordpress().equals(CS) && !c.getStatusNEwordpress().equals(CEP) || !c.getStatusTGwordpress().equals(CS) && !c.getStatusTGwordpress().equals(CEP));
                if (!b.booleanValue()) continue;
                this.connexionRepository.deleteByUsername(c.getUsername());
                Optional auteur = this.auteurRepository.findById((Object)c.getCompteID());
                if (auteur.isPresent()) {
                    if (((Auteur)auteur.get()).getPiece() != null && !Objects.equals(((Auteur)auteur.get()).getPiece(), "")) {
                        this.photoService.deletePhotoIdentite(((Auteur)auteur.get()).getPiece());
                    }
                    if (((Auteur)auteur.get()).getAutrepiece() != null && !Objects.equals(((Auteur)auteur.get()).getAutrepiece(), "")) {
                        this.photoService.deletePhotoIdentite(((Auteur)auteur.get()).getAutrepiece());
                    }
                }
                this.modePaiementRepository.deleteByAuteurID(c.getCompteID());
                this.paiementRepository.deleteByAuteurID(c.getCompteID());
                if (c.getRole().equals("contributeur")) {
                    List idsArticles = this.articleRepository.findIdByAuteurID(c.getCompteID());
                    if (!idsArticles.isEmpty()) {
                        this.articleService.deleteArticles(idsArticles);
                    }
                    this.pointsContributeurRepository.deleteByContributeurid(c.getCompteID());
                } else if (c.getRole().equals("ami")) {
                    this.recommandationRepository.deleteByAuteurid(c.getCompteID());
                    this.recommandationAunAmiRepository.deleteByAmiID(c.getCompteID());
                    this.pointsAmiRepository.deleteByAmiId(c.getCompteID());
                }
                this.auteurRepository.deleteById((Object)c.getCompteID());
                c.setAsupprimer(Boolean.valueOf(false));
            }
        }
    }

    @Transactional
    public UserInfoResponse SeConnecterAuCompteAuteur(String username, String pwd) {
        Auteur auteur = this.auteurRepository.findByUsername(username);
        if (auteur == null) {
            return null;
        }
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        String token = this.jwtUtils.generateTokenFromUsername(userDetails.getUsername(), userDetails.getPassword(), auteur.getId());
        Date date = new Date();
        UserInfoResponse userInfoResponse = new UserInfoResponse();
        Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
        if (con == null) {
            Connexion connexion = new Connexion();
            connexion.setUsername(username.toLowerCase());
            connexion.setToken(token);
            connexion.setDebutSession(date);
            connexion.setResultat("Connect\u00e9");
            connexion.setDateConnexion(date);
            connexion.setBug(Boolean.valueOf(false));
            Connexion connexion1 = (Connexion)this.connexionRepository.save((Object)connexion);
            userInfoResponse = new UserInfoResponse(token, auteur, 86400000, connexion1.getId());
        } else {
            userInfoResponse = new UserInfoResponse(token, auteur, 86400000, con.getId());
        }
        return userInfoResponse;
    }

    public ResponseEntity<List<AuteurPwdDTO>> getAllAuteurPwdDtos() throws JsonProcessingException {
        List auteurs = this.auteurRepository.findByRoleNot("admin");
        if (!auteurs.isEmpty()) {
            List auteurPwdDTOS = this.auteurMapper.AuteursToAuteurPwdDTO(auteurs);
            long contentLength = this.mapper.writeValueAsString((Object)auteurPwdDTOS).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteurPwdDTOS);
        }
        return null;
    }

    public ResponseEntity<List<DashbordStats>> getAdminDashboardStats() throws JsonProcessingException {
        List articles = this.articleRepository.findAll();
        ArrayList<DashbordStats> dashbordStats = new ArrayList<DashbordStats>();
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        if (!articles.isEmpty()) {
            for (int i = 0; i < articles.size(); ++i) {
                DashbordStats dashbordStats1 = new DashbordStats(((Article)articles.get(i)).getStatus(), format.format(((Article)articles.get(i)).getDateCreation()));
                dashbordStats.add(dashbordStats1);
            }
        }
        long contentLength = this.mapper.writeValueAsString(dashbordStats).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(dashbordStats);
    }

    public ResponseEntity<List<StatistiquesArticle>> getAdminStatistiques() throws IOException {
        List articles = this.articleRepository.findByStatusOrderByDateCreationDesc("Valid\u00e9 (en ligne)");
        ArrayList<StatistiquesArticle> statistiquesArticles = new ArrayList<StatistiquesArticle>();
        if (!articles.isEmpty()) {
            for (Article article : articles) {
                StatistiquesArticle s = new StatistiquesArticle();
                s.setLienarticle(article.getLink());
                s.setTitrearticle(article.getTitre());
                s.setCategorie(article.getCategorie());
                s.setDateCreation(article.getDateCreation());
                s.setPageViews(article.getPageViews());
                s.setDateDerniereVue(article.getDateDerniereVue());
                statistiquesArticles.add(s);
            }
        }
        long contentLength = this.mapper.writeValueAsString(statistiquesArticles).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(statistiquesArticles);
    }

    @Transactional
    public ResponseEntity<List<Bugs>> getAllBugs() throws JsonProcessingException {
        List bugsList = this.bugService.getAllBugs();
        long contentLength = this.mapper.writeValueAsString((Object)bugsList).getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)bugsList);
    }

    @Transactional
    public ResponseEntity<RecommandationAdminDTO> getAllRecommandations(int pageNumber) throws JsonProcessingException {
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)20);
        Page page = this.recommandationRepository.findAllByOrderByDateCreationDesc((Pageable)pageable);
        List recommandations = page.getContent();
        if (!recommandations.isEmpty()) {
            List recommandationAdmins = this.recommandationMapper.RecommandationsToRecommandationAdmin(recommandations);
            RecommandationAdminDTO recommandationAdminDTO = new RecommandationAdminDTO();
            recommandationAdminDTO.setRecommandations(recommandationAdmins);
            recommandationAdminDTO.setTotalPages(page.getTotalPages());
            long contentLength = this.mapper.writeValueAsString((Object)recommandationAdminDTO).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)recommandationAdminDTO);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<PaiementAdmin>> getAllPaiements() throws JsonProcessingException {
        List paiementAdmins = this.paiementAdminRepository.findAllByOrderByDateCreationDesc();
        if (!paiementAdmins.isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)paiementAdmins).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)paiementAdmins);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<PaiementAdmin>> ajouterPaiementAdmin(PaiementAdmin paiementAdmin) throws JsonProcessingException {
        List paiementAdmins;
        PaiementAdmin paiementAdmin1 = this.paiementAdminRepository.findByMois(paiementAdmin.getMois());
        if (paiementAdmin1 == null) {
            paiementAdmin.setEstconfirmer(Boolean.valueOf(false));
            this.paiementAdminRepository.save((Object)paiementAdmin);
            List auteurs = this.auteurRepository.findByMonetisationAndRoleIn("Oui", Arrays.asList("ami", "contributeur"));
            if (!auteurs.isEmpty()) {
                Transaction transaction;
                String moisprecedent = paiementAdmin.getMois();
                ArrayList<Auteur> amis = new ArrayList<Auteur>();
                ArrayList<Auteur> contributeurs = new ArrayList<Auteur>();
                ArrayList<Transaction> transactionList = new ArrayList<Transaction>();
                for (Auteur a : auteurs) {
                    if (a.getRole().equals("ami")) {
                        amis.add(a);
                        continue;
                    }
                    if (!a.getRole().equals("contributeur")) continue;
                    contributeurs.add(a);
                }
                ArrayList pointsAmiList = new ArrayList();
                ArrayList pointsContributeurList = new ArrayList();
                if (!amis.isEmpty()) {
                    for (Auteur auteur : amis) {
                        PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(moisprecedent, auteur.getId());
                        if (pointsAmi == null || pointsAmi.getNbPointsMois() <= 2L) continue;
                        transaction = new Transaction();
                        transaction.setAuteurid(auteur.getId());
                        transaction.setPoints(pointsAmi.getNbPointsMois());
                        transaction.setMois(moisprecedent);
                        transaction.setMonetisation(auteur.getMonetisation());
                        transaction.setNom(auteur.getLast_name());
                        transaction.setPeriode(paiementAdmin.getPeriode());
                        transaction.setPrenom(auteur.getFirst_name());
                        transaction.setTypecompte(auteur.getRole());
                        transaction.setPaiementid(paiementAdmin.getId());
                        transaction.setEstconfirmer(Boolean.valueOf(false));
                        transaction.setEstpayer(Boolean.valueOf(false));
                        transaction.setSmsenvoyer(Boolean.valueOf(false));
                        transaction.setDateCreationCompte(auteur.getDateCreation());
                        transactionList.add(transaction);
                    }
                }
                if (!contributeurs.isEmpty()) {
                    for (Auteur auteur : contributeurs) {
                        List pointsContributeurs = this.pointsContributeurRepository.findByMoisAndContributeurid(moisprecedent, auteur.getId());
                        if (pointsContributeurs.isEmpty()) continue;
                        transaction = new Transaction();
                        transaction.setAuteurid(auteur.getId());
                        transaction.setPoints(Long.valueOf(100L * (long)pointsContributeurs.size()));
                        transaction.setMois(moisprecedent);
                        transaction.setMonetisation(auteur.getMonetisation());
                        transaction.setNom(auteur.getLast_name());
                        transaction.setPeriode(paiementAdmin.getPeriode());
                        transaction.setPrenom(auteur.getFirst_name());
                        transaction.setTypecompte(auteur.getRole());
                        transaction.setPaiementid(paiementAdmin.getId());
                        transaction.setEstconfirmer(Boolean.valueOf(false));
                        transaction.setEstpayer(Boolean.valueOf(false));
                        transaction.setSmsenvoyer(Boolean.valueOf(false));
                        transaction.setDateCreationCompte(auteur.getDateCreation());
                        transactionList.add(transaction);
                    }
                }
                if (!transactionList.isEmpty()) {
                    paiementAdmin.setNbmembres(Long.valueOf(transactionList.size()));
                    Long totalpoints = 0L;
                    for (Transaction t : transactionList) {
                        totalpoints = totalpoints + t.getPoints();
                    }
                    paiementAdmin.setPoints(totalpoints);
                    this.paiementAdminRepository.save((Object)paiementAdmin);
                    for (Transaction t : transactionList) {
                        ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(t.getAuteurid());
                        if (modePaiement != null) {
                            t.setTypepaiement(modePaiement.getMode().toLowerCase());
                            if (modePaiement.getMode().equals("Western Union")) {
                                t.setOperateur(modePaiement.getPrenomb() + " " + modePaiement.getNomb());
                                t.setDestinataire(modePaiement.getPaysdest());
                            } else if (modePaiement.getMode().equals("Wallet")) {
                                t.setDestinataire(modePaiement.getNumero().substring(3));
                                if (modePaiement.getOperateur().equals("Free Money S\u00e9n\u00e9gal")) {
                                    t.setOperateur("freemoney");
                                } else {
                                    t.setOperateur(modePaiement.getOperateur().toLowerCase());
                                }
                            }
                        }
                        Long montant = Math.round((float)(t.getPoints() * paiementAdmin.getBudget()) / (float)paiementAdmin.getPoints().longValue());
                        t.setMontantcalculer(montant);
                        t.setMontantapayer(montant);
                    }
                    Transaction transaction2 = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
                    if (transaction2 != null) {
                        this.ref = transaction2.getParamref() + 1L;
                    }
                    for (Transaction t : transactionList) {
                        String refinterne = "NC" + this.ref;
                        t.setRefInterne(refinterne);
                        t.setParamref(this.ref);
                        this.ref = this.ref + 1L;
                    }
                    this.transactionRepository.saveAll(transactionList);
                }
            }
        }
        if (!(paiementAdmins = this.paiementAdminRepository.findAll()).isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)paiementAdmins).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)paiementAdmins);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<Transaction>> getTransactionsByPaiementAdmin(Long id) throws JsonProcessingException {
        List transactionList = this.transactionRepository.findByPaiementidOrderByIdDesc(id);
        if (!transactionList.isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)transactionList).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)transactionList);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<List<PaiementAdmin>> UpdateBudget(PaiementAdmin paiementAdmin) throws JsonProcessingException {
        Transaction transaction;
        this.paiementAdminRepository.save((Object)paiementAdmin);
        List transactionList = this.transactionRepository.findByPaiementidOrderByIdDesc(paiementAdmin.getId());
        if (!transactionList.isEmpty()) {
            for (Transaction t : transactionList) {
                Long montant = Math.round((float)(t.getPoints() * paiementAdmin.getBudget()) / (float)paiementAdmin.getPoints().longValue());
                t.setMontantcalculer(montant);
                t.setMontantapayer(montant);
            }
        }
        if ((transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc()) != null) {
            this.ref = transaction.getParamref() + 1L;
        }
        for (Transaction t : transactionList) {
            if (t.getRefInterne() != null) continue;
            String refinterne = "NC" + this.ref;
            t.setRefInterne(refinterne);
            t.setParamref(this.ref);
            this.ref = this.ref + 1L;
        }
        this.transactionRepository.saveAll((Iterable)transactionList);
        List paiementAdmins = this.paiementAdminRepository.findAllByOrderByDateCreationDesc();
        if (!paiementAdmins.isEmpty()) {
            long contentLength = this.mapper.writeValueAsString((Object)paiementAdmins).getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)paiementAdmins);
        }
        return null;
    }

    @Transactional
    public String UpdateMontantsTransactions(List<Transaction> transactionList) {
        if (!transactionList.isEmpty()) {
            Transaction transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
            if (transaction != null) {
                this.ref = transaction.getParamref() + 1L;
            }
            for (Transaction t : transactionList) {
                if (t.getRefInterne() != null) continue;
                String refinterne = "NC" + this.ref;
                t.setRefInterne(refinterne);
                t.setParamref(this.ref);
                this.ref = this.ref + 1L;
            }
            this.transactionRepository.saveAll(transactionList);
        }
        return "OK";
    }

    @Transactional
    public String ConfirmMontantsTransactions(List<Transaction> transactionList) {
        if (!transactionList.isEmpty()) {
            for (Transaction transaction : transactionList) {
                transaction.setEstconfirmer(Boolean.valueOf(true));
            }
            Transaction transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
            if (transaction != null) {
                this.ref = transaction.getParamref() + 1L;
            }
            for (Transaction t : transactionList) {
                if (t.getRefInterne() != null) continue;
                String refinterne = "NC" + this.ref;
                t.setRefInterne(refinterne);
                t.setParamref(this.ref);
                this.ref = this.ref + 1L;
            }
            this.transactionRepository.saveAll(transactionList);
            PaiementAdmin paiementAdmin = (PaiementAdmin)this.paiementAdminRepository.findById((Object)transactionList.get(0).getPaiementid()).get();
            paiementAdmin.setEstconfirmer(Boolean.valueOf(true));
            this.paiementAdminRepository.save((Object)paiementAdmin);
        }
        return "OK";
    }

    @Transactional
    public String ConfirmMontantsDigimp(List<Transaction> transactionList) {
        if (!transactionList.isEmpty()) {
            Transaction transaction = this.transactionRepository.findFirstByParamrefIsNotNullOrderByParamrefDesc();
            if (transaction != null) {
                this.ref = transaction.getParamref() + 1L;
            }
            for (Transaction t : transactionList) {
                if (t.getRefInterne() != null) continue;
                String refinterne = "NC" + this.ref;
                t.setRefInterne(refinterne);
                t.setParamref(this.ref);
                this.ref = this.ref + 1L;
            }
            this.transactionRepository.saveAll(transactionList);
        }
        return "OK";
    }

    private String generateRefInterne() {
        String refinterne = "NC" + this.ref;
        this.ref = this.ref + 1L;
        return refinterne;
    }

    @Transactional
    @Scheduled(cron="37 29 13 * * *", zone="GMT")
    public void SendSMSConfirmationPaiement() {
        List transactions = this.transactionRepository.findBySmsenvoyerAndEstconfirmerAndEstpayerAndTypepaiement(Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(true), "wallet");
        if (!transactions.isEmpty()) {
            List auteursSN;
            long coeff = Math.round((float)((Transaction)transactions.get(0)).getMontantcalculer().longValue() / (float)((Transaction)transactions.get(0)).getPoints().longValue());
            HashSet<Long> ids = new HashSet<Long>();
            for (Transaction t : transactions) {
                ids.add(t.getAuteurid());
            }
            List auteurs = this.auteurRepository.findByIdIn(new ArrayList(ids));
            if (!auteurs.isEmpty() && !(auteursSN = auteurs.stream().filter(a -> a.getPays().equals("S\u00e9n\u00e9gal")).collect(Collectors.toList())).isEmpty()) {
                String token = this.smsService.getAuthToken().getToken();
                for (Transaction t : transactions) {
                    Auteur auteur = auteursSN.stream().filter(a -> Objects.equals(a.getId(), t.getAuteurid())).findFirst().get();
                    if (auteur.getBloquer().booleanValue()) continue;
                    try {
                        NotificationSmsStatus notificationSmsStatus = this.smsService.EnvoyerSMSConfirmationPaiement(token, auteur, t, coeff);
                        if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                        t.setSmsenvoyer(Boolean.valueOf(true));
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                        System.out.println(e.getLocalizedMessage());
                        this.bugsCronService.SaveBugCron("Envoi SMS confirmation de la transaction d'id : " + t.getId(), e.getMessage() + "\n" + e.getLocalizedMessage());
                    }
                }
                this.transactionRepository.saveAll((Iterable)transactions);
            }
        }
    }
}

