/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.LesDTOs.NotificationSmsStatus;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.NotificationSms;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.NotificationSmsRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.SmsService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificationSmsService {
    @Autowired
    private NotificationSmsRepository notificationSmsRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private BugsCronService bugsCronService;

    @Transactional
    @Scheduled(cron="10 26 11 * * *", zone="GMT")
    public void SelectionnerNotificationsSms() {
        try {
            LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
            LocalDateTime datedebut = currentDate.withYear(2024).withMonth(2).withDayOfMonth(10).withHour(0).withMinute(0).withSecond(0);
            Date datededebut = Date.from(datedebut.atZone(ZoneId.of("GMT")).toInstant());
            List amisSms = this.auteurRepository.findAmiSms(datededebut);
            if (!amisSms.isEmpty() && !(amisSms = amisSms.stream().filter(a -> a.getUsername().startsWith("221") && (a.getEmail().equals("") || a.getEmail() == null || a.getEmail().endsWith("@notrecontinent.com"))).collect(Collectors.toList())).isEmpty()) {
                ArrayList<NotificationSms> notificationSmsList = new ArrayList<NotificationSms>();
                for (Auteur ami : amisSms) {
                    NotificationSms notificationSms = new NotificationSms();
                    notificationSms.setAmiid(ami.getId());
                    notificationSms.setEstenvoyer(Boolean.valueOf(false));
                    notificationSms.setNomami(ami.getFirst_name());
                    notificationSms.setNumero(ami.getUsername());
                    notificationSmsList.add(notificationSms);
                }
                this.notificationSmsRepository.saveAll(notificationSmsList);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de s\u00e9lection des notifications sms pour compte ami sans email", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="20 27 11 * * *", zone="GMT")
    public void EnvoyerNotificationAmiSms() {
        try {
            List notificationSmsList = this.notificationSmsRepository.findByEstenvoyer(Boolean.valueOf(false));
            if (!notificationSmsList.isEmpty()) {
                for (NotificationSms notificationSms : notificationSmsList) {
                    NotificationSmsStatus notificationSmsStatus = this.smsService.SendNotificationAmi(notificationSms.getNumero(), notificationSms.getNomami());
                    if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                    notificationSms.setStatus(notificationSmsStatus.getStatus());
                    notificationSms.setSms_id(notificationSmsStatus.getSms_id());
                    notificationSms.setDateenvoi(new Date());
                    notificationSms.setEstenvoyer(Boolean.valueOf(true));
                }
                this.notificationSmsRepository.saveAll((Iterable)notificationSmsList);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron d'envoi des notifications sms pour compte ami sans email", e.getMessage());
        }
    }

    public void VerifierStatusNotification() {
    }
}

