/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsContributeur;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointsContributeurRepository;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PointsContributeurService {
    @Autowired
    private PointsContributeurRepository pointsContributeurRepository;
    @Autowired
    private AuteurRepository auteurRepository;

    @Transactional
    public void ReloadPointsContributeur() {
        List pointsContributeurList = this.pointsContributeurRepository.findAll();
        if (!pointsContributeurList.isEmpty()) {
            HashSet<Long> contributeursids = new HashSet<Long>();
            for (PointsContributeur p2 : pointsContributeurList) {
                contributeursids.add(p2.getContributeurid());
            }
            ArrayList contributeuridsList = new ArrayList(contributeursids);
            if (!contributeuridsList.isEmpty()) {
                for (Long contributeurid : contributeuridsList) {
                    List pointsContributeurs = pointsContributeurList.stream().filter(p -> Objects.equals(p.getContributeurid(), contributeurid)).collect(Collectors.toList());
                    if (pointsContributeurs.isEmpty()) continue;
                    Auteur contributeur = (Auteur)this.auteurRepository.findById((Object)contributeurid).get();
                    Long totalpoints = 0L;
                    for (PointsContributeur p3 : pointsContributeurs) {
                        totalpoints = totalpoints + p3.getNbpoints();
                    }
                    contributeur.setTotalPointsCumules(totalpoints);
                    this.auteurRepository.save((Object)contributeur);
                }
            }
        }
    }

    public List<PointsContributeur> getAllByContributeurid(Long id) {
        return this.pointsContributeurRepository.findByContributeurid(id);
    }

    @Transactional
    public void VerifAndAddPointContributeur(String lienarticle, String titrearticle, Long contributeurid, String statusarticle) {
        PointsContributeur pointsContributeur = this.pointsContributeurRepository.findByLienarticle(lienarticle);
        if (pointsContributeur == null) {
            PointsContributeur p = new PointsContributeur();
            p.setLienarticle(lienarticle);
            p.setTitrearticle(titrearticle);
            p.setContributeurid(contributeurid);
            p.setStatusarticle(statusarticle);
            if (statusarticle.equals("Valid\u00e9 (en ligne)")) {
                p.setNbpoints(Long.valueOf(100L));
            }
            LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
            Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            String mois = dateFormat.format(currentdate);
            p.setMois(mois);
            this.pointsContributeurRepository.save((Object)p);
        }
    }
}

