/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.LesDTOs.CoordonneesRecepteurDto;
import com.notrecontinent.webapi.LesDTOs.NotificationSmsStatus;
import com.notrecontinent.webapi.LesDTOs.RecommandationAunAmiDTO;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.RecommandationAunAmi;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.SmsService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RecommandationAunAmiService {
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private MailService mailService;

    @Transactional
    @Scheduled(cron="25 */30 * * * *")
    public void EnvoyerSmsRecommandationAunAmi() {
        try {
            List recommandationAunAmiList = this.recommandationAunAmiRepository.findByEstenvoyer(Boolean.valueOf(false));
            if (!recommandationAunAmiList.isEmpty()) {
                for (RecommandationAunAmi r : recommandationAunAmiList) {
                    if (r.getAenvoyerpar().equals("sms")) {
                        String expediteurname = "";
                        int nbchars = r.getNomExpediteur().length() + r.getPrenomExpediteur().length();
                        expediteurname = nbchars > 17 ? r.getPrenomExpediteur() : r.getPrenomExpediteur() + " " + r.getNomExpediteur();
                        NotificationSmsStatus notificationSmsStatus = this.smsService.EnvoyerSmsRecommandationAunAmi(r.getNumeroExpediteur(), expediteurname, r.getTeldestinataire(), r.getPrenomdestinataire() + " " + r.getNomdestinataire(), r.getMessage());
                        if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                        r.setEstenvoyer(Boolean.valueOf(true));
                        r.setDateenvoi(new Date());
                        continue;
                    }
                    if (!r.getAenvoyerpar().equals("email")) continue;
                    this.mailService.EnvoyerEmailRecommandationAunAmi(r.getNumeroExpediteur(), r.getPrenomExpediteur() + " " + r.getNomExpediteur(), r.getPrenomdestinataire(), r.getTeldestinataire(), r.getMessage());
                    r.setEstenvoyer(Boolean.valueOf(true));
                    r.setDateenvoi(new Date());
                }
                this.recommandationAunAmiRepository.saveAll((Iterable)recommandationAunAmiList);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron d'envoi des Recommandations \u00e0 un ami par sms", e.getMessage());
        }
    }

    public List<RecommandationAunAmi> getRecommandationsAunAmiBidAmiID(Long id) {
        return this.recommandationAunAmiRepository.findByAmiID(id);
    }

    @Transactional
    public String AjouterRecommandationAunAmi(RecommandationAunAmiDTO recommandationAunAmiDTO) {
        ArrayList<RecommandationAunAmi> recommandationAunAmiList = new ArrayList<RecommandationAunAmi>();
        if (!recommandationAunAmiDTO.getRecepteurs().isEmpty()) {
            for (CoordonneesRecepteurDto recepteur : recommandationAunAmiDTO.getRecepteurs()) {
                if (recepteur == null) continue;
                RecommandationAunAmi recommandationAunAmi = new RecommandationAunAmi();
                recommandationAunAmi.setAmiID(recommandationAunAmiDTO.getAmiID());
                recommandationAunAmi.setNomExpediteur(recommandationAunAmiDTO.getNomExpediteur());
                recommandationAunAmi.setPrenomExpediteur(recommandationAunAmiDTO.getPrenomExpediteur());
                recommandationAunAmi.setNumeroExpediteur(recommandationAunAmiDTO.getNumeroExpediteur());
                recommandationAunAmi.setEstenvoyer(Boolean.valueOf(false));
                recommandationAunAmi.setAenvoyerpar(recommandationAunAmiDTO.getAenvoyerpar());
                recommandationAunAmi.setMessage(recommandationAunAmiDTO.getMessage());
                recommandationAunAmi.setNomdestinataire(recepteur.getNom());
                recommandationAunAmi.setPrenomdestinataire(recepteur.getPrenom());
                recommandationAunAmi.setTeldestinataire(recepteur.getNumeroMobile());
                recommandationAunAmiList.add(recommandationAunAmi);
            }
            this.recommandationAunAmiRepository.saveAll(recommandationAunAmiList);
            LocalDateTime now = LocalDateTime.now(ZoneId.of("GMT"));
            Date currentdate = Date.from(now.atZone(ZoneId.of("GMT")).toInstant());
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            String mois = dateFormat.format(currentdate);
            PointsAmi pointsAmi = this.pointsAmiRepository.findByMoisAndAmiId(mois, recommandationAunAmiDTO.getAmiID());
            Auteur ami = (Auteur)this.auteurRepository.findById((Object)recommandationAunAmiDTO.getAmiID()).get();
            if (pointsAmi == null) {
                PointsAmi p = new PointsAmi();
                p.setAmiId(recommandationAunAmiDTO.getAmiID());
                p.setMois(mois);
                p.setNbArticlesLus(Long.valueOf(0L));
                p.setNbPointsArticlesLus(Long.valueOf(0L));
                p.setNbPointsMois(Long.valueOf(5L * (long)recommandationAunAmiList.size()));
                p.setNbArticlesLus(Long.valueOf(0L));
                p.setNbRecommandations(Long.valueOf(recommandationAunAmiList.size()));
                p.setNbPointsRecommandations(Long.valueOf(5L * (long)recommandationAunAmiList.size()));
                p.setNbMissions(Long.valueOf(0L));
                p.setNbPointsMissions(Long.valueOf(0L));
                ami.setTotalPointsCumules(Long.valueOf(5L * (long)recommandationAunAmiList.size()));
                this.auteurRepository.save((Object)ami);
                this.pointsAmiRepository.save((Object)p);
            } else {
                pointsAmi.setNbPointsMois(Long.valueOf(pointsAmi.getNbPointsMois() + 5L * (long)recommandationAunAmiList.size()));
                pointsAmi.setNbRecommandations(Long.valueOf(pointsAmi.getNbRecommandations() + (long)recommandationAunAmiList.size()));
                pointsAmi.setNbPointsRecommandations(Long.valueOf(pointsAmi.getNbPointsRecommandations() + 5L * (long)recommandationAunAmiList.size()));
                ami.setTotalPointsCumules(Long.valueOf(ami.getTotalPointsCumules() + 5L * (long)recommandationAunAmiList.size()));
                this.auteurRepository.save((Object)ami);
                this.pointsAmiRepository.save((Object)pointsAmi);
            }
        }
        return "Recommandation(s) ajout\u00e9e(s)";
    }
}

