/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;

@Service
public class MailService {
    @Autowired
    private JavaMailSender mailSender;

    public String sendCreationCompteEmail(String username) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un nouveau compte vient d'\u00eatre cr\u00e9\u00e9.</p>";
        body = body + "<p><b>Identifiant:</b> " + username + "</p>";
        String subject = "Nouveau compte";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("creationcompte@notrecontinent.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String connexionEmail(String username, String date) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Le cr\u00e9ateur de contenu qui avait cr\u00e9er un compte le <b>" + date + "</b> avec l'identifiant <b>" + username + "</b> vient de se connecter.</p>";
        String subject = "Nouvelle connexion";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("connexioncompte@notrecontinent.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendProfilEmail(String username, String civilite, String prenom, String nom, String adresse, String pays, String departement, String typecompte, String pseudonyme) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un cr\u00e9ateur de contenu vient de renseigner son profil.</p>";
        body = body + "<p><b>Identifiant:</b> " + username + "</p>";
        body = body + "<p><b>Civilit\u00e9:</b> " + civilite + " </p>";
        body = body + "<p><b>Pr\u00e9nom:</b> " + prenom + "</p>";
        body = body + "<p><b>Nom:</b> " + nom + "</p>";
        body = body + "<p><b>Adresse:</b> " + adresse + "</p>";
        body = body + "<p><b>Pays:</b> " + pays + "</p>";
        body = body + "<p><b>D\u00e9partement:</b> " + departement + "</p>";
        body = body + "<p><b>Type de compte:</b> " + typecompte + "</p>";
        body = body + "<p><b>Pseudonyme:</b> " + pseudonyme + "</p>";
        String subject = "Profil renseign\u00e9";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("creationprofil@notrecontinent.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendErreurConnexionMail(String username, String password) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String body = "<p>Un utilisateur viend de rencontrer un \u00e9chec de connexion sur https://dev.speakyfree.com .</p>";
        body = body + "<br>";
        body = body + "<p>Username: " + username + "</p>";
        String subject = "Nouvelle tentative de connexion";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo("erreurconnexioncompte@notrecontinent.com");
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendValidationCompteEmail(String username, String token) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour, " : "Bonsoir, ";
        String lien = "https://dev.speakyfree.com/validation-email/" + token + "/" + username;
        String lienValidation = "<a href=\"" + lien + "\">" + lien + "</a>";
        String body = "<p>" + salutation + "</p>";
        body = body + "<p>Veuillez cliquer sur le lien ci-dessous pour confirmer la cr\u00e9ation de votre compte : </p>";
        body = body + "<br><p>" + lienValidation + "</p>";
        body = body + "<br><br>";
        body = body + "<p>Ce lien expire dans 15 minutes.</p>";
        String subject = "Validation de compte Speakyfree";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo(username);
        helper.setSubject(subject);
        helper.setText(body, true);
        System.out.println(username);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String sendValidationResetEmail(String username, String token) throws IOException, MessagingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour, " : "Bonsoir, ";
        String lien = "https://dev.speakyfree.com/reinitialisation-motdepasse/" + token + "/" + username;
        String lienValidation = "<a href=\"" + lien + "\">" + lien + "</a>";
        String body = "<p>" + salutation + "</p>";
        body = body + "<p>Veuillez cliquer sur le lien ci-dessous pour r\u00e9initialiser votre mot de passe : </p>";
        body = body + "<br><p>" + lienValidation + "</p>";
        body = body + "<br><br>";
        body = body + "<p>Ce lien expire dans 15 minutes.</p>";
        String subject = "R\u00e9initialisation de mot de passe Speakyfree";
        helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
        helper.setTo(username);
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public String EnvoyerEmailRecommandationAunAmi(String numeroExpediteur, String nomExpediteur, String nomRecepteur, String numeroRecepteur, String msg) throws MessagingException, UnsupportedEncodingException {
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message, true);
        String salutation = "";
        LocalTime localTime = LocalTime.now();
        int currentHour = localTime.getHour();
        salutation = currentHour <= 12 ? "Bonjour" : "Bonsoir";
        String lien = "<a href=\"https://dev.speakyfree.com/inscription\">cliquer ici</a>";
        String lien2 = "<a href=\"https://sn.notrecontinent.com\">cliquant ici</a>";
        String body = "<p>Bonjour " + nomRecepteur + ", c'est " + nomExpediteur + ", </p>";
        body = body + "<p>Comme j'utilise la plateforme de Notre Continent pour t'envoyer ce mail voici mon adresse email pour que tu puisses savoir que c'est bien moi " + numeroExpediteur + ".</p>";
        body = body + "<p>Je te recommande de cr\u00e9er ton compte \u00ab Ami(e) \u00bb sur le site de NOTRE CONTINENT, ils ont un syst\u00e8me tr\u00e8s int\u00e9ressant de r\u00e9mun\u00e9ration des visiteurs tout en te donnant des informations utiles.</p>";
        body = body + "<p>Tu peux " + lien + " pour cr\u00e9er ton compte ou aller sur leur site web en " + lien2 + ".</p>";
        body = body + "<p>Bien \u00e0 toi</p>";
        body = body + "<p>" + nomExpediteur + "</p>";
        body = body + "<p>" + numeroExpediteur + "</p>";
        String subject = nomRecepteur + ", donne un coup d'\u0153il sur ma recommandation";
        helper.setFrom("infosn@notrecontinent.net", nomExpediteur);
        helper.setTo(numeroRecepteur);
        helper.setSubject(subject);
        helper.setText(body, true);
        this.mailSender.send(message);
        return "mail successfully sent";
    }

    public List<Long> envoyerAlertesClics(List<List<String>> emails) {
        ArrayList<Long> idsamis = new ArrayList<Long>();
        MimeMessage message = this.mailSender.createMimeMessage();
        MimeMessageHelper helper = null;
        try {
            helper = new MimeMessageHelper(message, true);
            String salutation = "";
            LocalTime localTime = LocalTime.now();
            int currentHour = localTime.getHour();
            salutation = currentHour <= 12 ? "Bonjour " : "Bonsoir ";
            for (List<String> email : emails) {
                String body = "<p>" + salutation + " " + email.get(2) + ", il est interdit de cliquer sur deux articles recommandations en moins de 2 minutes. </p>";
                String subject = "Alerte clic recommadations";
                try {
                    helper.setFrom("infosn@notrecontinent.net", "Notre Continent");
                    helper.setTo(email.get(1));
                    helper.setSubject(subject);
                    helper.setText(body, true);
                    this.mailSender.send(message);
                    idsamis.add(Long.valueOf(email.get(0)));
                }
                catch (UnsupportedEncodingException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (MessagingException e) {
            System.out.println(e.getMessage());
        }
        return idsamis;
    }
}

