/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.notrecontinent.webapi.LesDTOs.CompteWP;
import com.notrecontinent.webapi.LesDTOs.CountryDTO;
import com.notrecontinent.webapi.LesDTOs.DashboardAmiDTO;
import com.notrecontinent.webapi.LesDTOs.DashboardContributeurDTO;
import com.notrecontinent.webapi.LesDTOs.UsernamePassword;
import com.notrecontinent.webapi.LesDTOs.WhatsappDTO;
import com.notrecontinent.webapi.dto.CompteWordpress;
import com.notrecontinent.webapi.dto.DashbordStats;
import com.notrecontinent.webapi.dto.VerifCode;
import com.notrecontinent.webapi.entities.Article;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.Connexion;
import com.notrecontinent.webapi.entities.PointsAmi;
import com.notrecontinent.webapi.entities.Recommandation;
import com.notrecontinent.webapi.enumeration.SubdomainsPaysEnum;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ConnexionRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.response.UserInfoResponse;
import com.notrecontinent.webapi.security.jwt.JwtUtils;
import com.notrecontinent.webapi.security.services.UserDetailsImpl;
import com.notrecontinent.webapi.services.AuteurService;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.PhotoService;
import com.notrecontinent.webapi.services.SmsService;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.mail.MessagingException;
import net.coobird.thumbnailator.Thumbnails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AuteurService {
    private final Path rootIdentites = Paths.get("/home/speak2024/dev.speakyfree.com/Identites", new String[0]);
    private final String dateFormat = "dd-MM-yyyy HH:mm:ss";
    @Autowired
    private PhotoService photoService;
    @Autowired
    private MailService mailService;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private ConnexionRepository connexionRepository;
    @Autowired
    AuthenticationManager authenticationManager;
    @Autowired
    JwtUtils jwtUtils;
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private UserDetailsService userDetailsService;
    String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
    String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    @Scheduled(cron="7 */5 * * * *", zone="GMT")
    @Transactional
    public void UpdateAuteursToWP() {
        try {
            List auteurList = this.auteurRepository.findByAmodifierWP(Boolean.valueOf(true));
            if (!auteurList.isEmpty()) {
                block2: for (Auteur auteur : auteurList) {
                    for (SubdomainsPaysEnum subdomainsPaysEnum : SubdomainsPaysEnum.values()) {
                        HttpEntity requestEntity;
                        String authHeader;
                        HttpHeaders header;
                        String email;
                        if (!subdomainsPaysEnum.getCountry().equals(auteur.getPays())) continue;
                        CompteWP compte = new CompteWP();
                        compte.setFirst_name(auteur.getFirst_name());
                        compte.setLast_name(auteur.getLast_name());
                        compte.setName(auteur.getName());
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                        if (auteur.getEmail() != null) {
                            email = "PL-" + simpleDateFormat.format(auteur.getDateCreation()) + "-" + auteur.getEmail();
                            compte.setEmail(email);
                        } else if (auteur.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                            email = "PL-" + simpleDateFormat.format(auteur.getDateCreation()) + "-" + auteur.getUsername() + "@notrecontinent.com";
                            compte.setEmail(email);
                        }
                        if (subdomainsPaysEnum.getSubdomain().equals("https://sn.notrecontinent.com")) {
                            if (auteur.getWordpressID() != null) {
                                header = new HttpHeaders();
                                authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
                                header.set("Authorization", authHeader);
                                requestEntity = new HttpEntity((Object)compte, (MultiValueMap)header);
                                String string = (String)this.restTemplate.exchange(subdomainsPaysEnum.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                            }
                        } else {
                            header = new HttpHeaders();
                            authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                            header.set("Authorization", authHeader);
                            requestEntity = new HttpEntity((Object)compte, (MultiValueMap)header);
                            this.ModifierCompteWP(subdomainsPaysEnum, auteur, requestEntity);
                        }
                        auteur.setAmodifierWP(Boolean.valueOf(false));
                        continue block2;
                    }
                }
                this.auteurRepository.saveAll((Iterable)auteurList);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de modification du profil d'un compte dans Wordpress", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="0 */2 * * * *", zone="GMT")
    public void RepliquerComptes() {
        try {
            List auteurs = this.auteurRepository.findByArepliquer(Boolean.valueOf(true));
            if (!auteurs.isEmpty()) {
                for (Auteur auteur : auteurs) {
                    HttpHeaders headers = new HttpHeaders();
                    String authHeader = "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes());
                    String authHeaderci = "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
                    headers.set("Authorization", authHeader);
                    HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                    HttpHeaders headers1 = new HttpHeaders();
                    headers1.set("Authorization", authHeaderci);
                    CompteWordpress compteWordpress = new CompteWordpress();
                    String email = "PL-" + sdf.format(auteur.getDateCreation()) + "-" + auteur.getUsername();
                    if (auteur.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                        email = email + "@notrecontinent.com";
                    }
                    compteWordpress.setEmail(email);
                    compteWordpress.setUsername(auteur.getUsername());
                    compteWordpress.setPassword(auteur.getPassword());
                    for (SubdomainsPaysEnum subdomain : SubdomainsPaysEnum.values()) {
                        CompteWordpress compteWordpress1;
                        HttpEntity compteWordpressHttpEntity;
                        if (subdomain.getSubdomain().equals("https://sn.notrecontinent.com")) {
                            compteWordpressHttpEntity = new HttpEntity((Object)compteWordpress, (MultiValueMap)headers);
                            System.out.println(subdomain.getSubdomain());
                            compteWordpress1 = (CompteWordpress)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users", HttpMethod.POST, compteWordpressHttpEntity, CompteWordpress.class, new Object[0]).getBody();
                            this.AffecterWPid(subdomain, auteur, compteWordpress1.getId());
                            continue;
                        }
                        compteWordpressHttpEntity = new HttpEntity((Object)compteWordpress, (MultiValueMap)headers1);
                        System.out.println(subdomain.getSubdomain());
                        compteWordpress1 = (CompteWordpress)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users", HttpMethod.POST, compteWordpressHttpEntity, CompteWordpress.class, new Object[0]).getBody();
                        this.AffecterWPid(subdomain, auteur, compteWordpress1.getId());
                    }
                    auteur.setArepliquer(Boolean.valueOf(false));
                }
                this.auteurRepository.saveAll((Iterable)auteurs);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de r\u00e9plication des comptes vers les back offices Wordpress", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="0 3 10 * * *")
    public void genererPasswordControle() {
        List auteurs = this.auteurRepository.findByRoleNot("admin");
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                String pwdcontrol = this.generateRandomString(15);
                auteur.setPasswordcontrole(pwdcontrol);
                auteur.setPasswordcontroleEncrypted(this.bCryptPasswordEncoder.encode((CharSequence)pwdcontrol));
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
    }

    public WhatsappDTO enregistrer1234(String numwhatsapp) {
        Auteur auteur = this.auteurRepository.findFirstByNumwhatsapp(numwhatsapp);
        WhatsappDTO whatsappDTO = new WhatsappDTO();
        if (auteur != null) {
            auteur.setCode1234envoyer(Boolean.valueOf(true));
            this.auteurRepository.save((Object)auteur);
            whatsappDTO.setNumero(numwhatsapp);
            whatsappDTO.setReponse("OK");
            return whatsappDTO;
        }
        whatsappDTO.setNumero(numwhatsapp);
        whatsappDTO.setReponse("auteurnonexists");
        return whatsappDTO;
    }

    public Boolean verifiercode1234(Long amiID) {
        Auteur ami = (Auteur)this.auteurRepository.findById((Object)amiID).get();
        if (ami.getCode1234envoyer().booleanValue()) {
            return true;
        }
        return false;
    }

    @Transactional
    public UserInfoResponse ConnecterAdmin(String login, String pwd) {
        Auteur admin = this.auteurRepository.findByUsernameAndBloquerAndRole(login.toLowerCase(), Boolean.valueOf(false), "admin");
        if (admin == null) {
            Date date = new Date();
            Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(login.toLowerCase(), date);
            if (con == null) {
                Connexion connexion = new Connexion();
                connexion.setUsername(login.toLowerCase());
                connexion.setResultat("Login admin incorrect");
                connexion.setDateConnexion(date);
                this.connexionRepository.save((Object)connexion);
            }
            return null;
        }
        if (this.bCryptPasswordEncoder.matches((CharSequence)pwd, admin.getPassword())) {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)login.toLowerCase(), (Object)pwd));
            SecurityContextHolder.getContext().setAuthentication(authentication);
            UserDetailsImpl userDetails = (UserDetailsImpl)authentication.getPrincipal();
            String token = this.jwtUtils.generateTokenFromUsername(userDetails.getUsername(), userDetails.getPassword(), admin.getId());
            Date date = new Date();
            UserInfoResponse userInfoResponse = new UserInfoResponse();
            Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(login.toLowerCase(), date);
            if (con == null) {
                Connexion connexion = new Connexion();
                connexion.setUsername(login.toLowerCase());
                connexion.setToken(token);
                connexion.setDebutSession(date);
                connexion.setResultat("Connect\u00e9");
                connexion.setDateConnexion(date);
                connexion.setBug(Boolean.valueOf(false));
                Connexion connexion1 = (Connexion)this.connexionRepository.save((Object)connexion);
                userInfoResponse = new UserInfoResponse(token, admin, 86400000, connexion1.getId());
            } else {
                userInfoResponse = new UserInfoResponse(token, admin, 86400000, con.getId());
            }
            return userInfoResponse;
        }
        Date date = new Date();
        Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(login.toLowerCase(), date);
        if (con == null) {
            Connexion connexion = new Connexion();
            connexion.setUsername(login.toLowerCase());
            connexion.setResultat("Mot de passe incorrect");
            connexion.setDateConnexion(date);
            this.connexionRepository.save((Object)connexion);
        }
        return null;
    }

    public String generateRandomString(int length) {
        String SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".length());
            char randomChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".charAt(randomIndex);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    public void resizeImage(String inputImagePath, String outputImagePath) {
        try {
            File fileToDelete = new File(outputImagePath);
            if (fileToDelete.exists()) {
                fileToDelete.delete();
            }
            Thumbnails.of((String[])new String[]{inputImagePath}).size(200, 200).outputQuality(1.0).outputFormat("jpeg").toFile(outputImagePath);
            System.out.println("image resized to 200 x 200");
        }
        catch (IOException e) {
            System.out.println("IMAGE NOT RESIZED TO 200 x 200");
        }
    }

    private long calculateContentLength(List<DashbordStats> list) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(list);
        return jsonString.getBytes().length;
    }

    public ResponseEntity<List<DashbordStats>> getDashboardStatsByAuteurID(Long id) throws JsonProcessingException {
        List articles = this.articleRepository.findByAuteurID(id);
        ArrayList<DashbordStats> dashbordStats = new ArrayList<DashbordStats>();
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        if (!articles.isEmpty()) {
            for (int i = 0; i < articles.size(); ++i) {
                DashbordStats dashbordStats1 = new DashbordStats(((Article)articles.get(i)).getStatus(), format.format(((Article)articles.get(i)).getDateCreation()));
                dashbordStats.add(dashbordStats1);
            }
        }
        long contentLength = this.calculateContentLength(dashbordStats);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(dashbordStats);
    }

    public ResponseEntity<DashboardContributeurDTO> getDashboardStatscoteserveurByAuteurID(Long id) throws JsonProcessingException {
        List articles = this.articleRepository.findByAuteurID(id);
        SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        DashboardContributeurDTO dashboardContributeurDTO = new DashboardContributeurDTO();
        LocalDate currentDate = LocalDate.now();
        String premiermois = currentDate.getMonth().getDisplayName(TextStyle.FULL, Locale.FRANCE) + " " + currentDate.getYear();
        LocalDate currentDateminus1Month = currentDate.minusMonths(1L);
        String deuxiemeMois = currentDateminus1Month.getMonth().getDisplayName(TextStyle.FULL, Locale.FRANCE) + " " + currentDateminus1Month.getYear();
        LocalDate currentDateminus2Month = currentDate.minusMonths(2L);
        String troisiememois = currentDateminus2Month.getMonth().getDisplayName(TextStyle.FULL, Locale.FRANCE) + " " + currentDateminus2Month.getYear();
        dashboardContributeurDTO.setDeuxiemeMois(deuxiemeMois);
        dashboardContributeurDTO.setPremiermois(premiermois);
        dashboardContributeurDTO.setTroisiememois(troisiememois);
        if (!articles.isEmpty()) {
            int nbArticlePremierMois = 0;
            int nbArticleDeuxiemeMois = 0;
            int nbArticleTroisiemeMois = 0;
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMMM yyyy", new Locale("fr"));
            for (Article article : articles) {
                String currentMonthNameAndyear = dateFormat.format(article.getDateCreation());
                if (currentMonthNameAndyear.equals(premiermois)) {
                    ++nbArticlePremierMois;
                    continue;
                }
                if (currentMonthNameAndyear.equals(deuxiemeMois)) {
                    ++nbArticleDeuxiemeMois;
                    continue;
                }
                if (!currentMonthNameAndyear.equals(troisiememois)) continue;
                ++nbArticleTroisiemeMois;
            }
            int nbArticlesValides = (int)articles.stream().filter(a -> a.getStatus().equals("Valid\u00e9 (en ligne)")).count();
            int nbArticlesValidationencours = (int)articles.stream().filter(a -> a.getStatus().equals("Validation en cours")).count();
            int nbArticlesBrouillon = (int)articles.stream().filter(a -> a.getStatus().equals("Brouillon")).count();
            int nbArticlesRejetes = (int)articles.stream().filter(a -> a.getStatus().equals("Rejet\u00e9")).count();
            dashboardContributeurDTO.setNbArticleTroisiemeMois(nbArticleTroisiemeMois);
            dashboardContributeurDTO.setNbArticlePremierMois(nbArticlePremierMois);
            dashboardContributeurDTO.setNbArticleDeuxiemeMois(nbArticleDeuxiemeMois);
            dashboardContributeurDTO.setNbArticlesBrouillon(nbArticlesBrouillon);
            dashboardContributeurDTO.setNbArticlesRejetes(nbArticlesRejetes);
            dashboardContributeurDTO.setNbArticlesValides(nbArticlesValides);
            dashboardContributeurDTO.setNbArticlesValidationencours(nbArticlesValidationencours);
        }
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)dashboardContributeurDTO);
        long contentLength = jsonString.getBytes().length;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentLength(contentLength);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)dashboardContributeurDTO);
    }

    public ResponseEntity<DashboardAmiDTO> getDashboardStatscoteserveurByAmiID(Long id) {
        DashboardAmiDTO dashboardAmiDTO = new DashboardAmiDTO();
        LocalDate currentDate = LocalDate.now();
        String premiermois = currentDate.getMonth().getDisplayName(TextStyle.FULL, Locale.FRANCE) + " " + currentDate.getYear();
        LocalDate currentDateminus1Month = currentDate.minusMonths(1L);
        String deuxiemeMois = currentDateminus1Month.getMonth().getDisplayName(TextStyle.FULL, Locale.FRANCE) + " " + currentDateminus1Month.getYear();
        LocalDate currentDateminus2Month = currentDate.minusMonths(2L);
        String troisiememois = currentDateminus2Month.getMonth().getDisplayName(TextStyle.FULL, Locale.FRANCE) + " " + currentDateminus2Month.getYear();
        dashboardAmiDTO.setDeuxiemeMois(deuxiemeMois);
        dashboardAmiDTO.setPremiermois(premiermois);
        dashboardAmiDTO.setTroisiememois(troisiememois);
        try {
            PointsAmi pointsAmiPremierMois = this.pointsAmiRepository.findByMoisAndAmiId(premiermois, id);
            PointsAmi pointsAmisecondMois = this.pointsAmiRepository.findByMoisAndAmiId(deuxiemeMois, id);
            PointsAmi pointsAmitroisiemeMois = this.pointsAmiRepository.findByMoisAndAmiId(troisiememois, id);
            if (pointsAmiPremierMois != null) {
                dashboardAmiDTO.setNbPointsMois(pointsAmiPremierMois.getNbPointsMois());
                dashboardAmiDTO.setNbPointsPremierMois(pointsAmiPremierMois.getNbPointsMois());
                dashboardAmiDTO.setNbArticlesLus(pointsAmiPremierMois.getNbArticlesLus());
                dashboardAmiDTO.setNbPointsArticlesLus(pointsAmiPremierMois.getNbPointsArticlesLus());
                dashboardAmiDTO.setNbRecommandations(pointsAmiPremierMois.getNbRecommandations());
                dashboardAmiDTO.setNbPointsRecommandations(pointsAmiPremierMois.getNbPointsRecommandations());
                dashboardAmiDTO.setNbMissions(pointsAmiPremierMois.getNbMissions());
                dashboardAmiDTO.setNbPointsMissions(pointsAmiPremierMois.getNbPointsMissions());
            }
            if (pointsAmisecondMois != null) {
                dashboardAmiDTO.setNbPointsDeuxiemeMois(pointsAmisecondMois.getNbPointsMois());
            }
            if (pointsAmitroisiemeMois != null) {
                dashboardAmiDTO.setNbPointsTroisiemeMois(pointsAmitroisiemeMois.getNbPointsMois());
            }
            Auteur ami = (Auteur)this.auteurRepository.findById((Object)id).get();
            dashboardAmiDTO.setNbPointsCumules(ami.getTotalPointsCumules());
            List recommandations = this.recommandationRepository.findTop3ByAuteuridAndEstcliquerOrderByDateClickDesc(id, Boolean.valueOf(true));
            if (!recommandations.isEmpty()) {
                dashboardAmiDTO.setTitrearticle1(((Recommandation)recommandations.get(0)).getTitrearticle());
                dashboardAmiDTO.setLienarticle1(((Recommandation)recommandations.get(0)).getLienarticle());
                if (recommandations.size() >= 2) {
                    dashboardAmiDTO.setLienarticle2(((Recommandation)recommandations.get(1)).getLienarticle());
                    dashboardAmiDTO.setTitrearticle2(((Recommandation)recommandations.get(1)).getTitrearticle());
                }
                if (recommandations.size() == 3) {
                    dashboardAmiDTO.setLienarticle3(((Recommandation)recommandations.get(2)).getLienarticle());
                    dashboardAmiDTO.setTitrearticle3(((Recommandation)recommandations.get(2)).getTitrearticle());
                }
            }
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString((Object)dashboardAmiDTO);
            long contentLength = jsonString.getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentLength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)dashboardAmiDTO);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Auteur> getAllAuteurs() {
        return this.auteurRepository.findAll();
    }

    public Boolean verifUsername(String username, String pays) {
        return this.auteurRepository.existsByUsernameAndBloquer(username.toLowerCase(), Boolean.valueOf(false));
    }

    @Transactional
    public String verifEmailAndSendResetPwdEmail(String username, String pays) throws MessagingException, IOException {
        Boolean b = this.auteurRepository.existsByUsernameAndBloquer(username.toLowerCase(), Boolean.valueOf(false));
        if (!b.booleanValue()) {
            return "notexists";
        }
        String token = this.jwtUtils.generateTokenFromUsernameOnly(username.toLowerCase());
        System.out.println(token);
        System.out.println(token);
        return this.mailService.sendValidationResetEmail(username.toLowerCase(), token);
    }

    @Transactional
    public Boolean verifResetPwdToken(String token, String email) throws MessagingException, IOException {
        Boolean b = this.jwtUtils.validateJwtToken(token);
        if (b.booleanValue()) {
            String mail = this.jwtUtils.getUserNameFromJwtToken(token);
            if (mail.equals(email.toLowerCase())) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean verifierUsernameUniquement(String username, String pays) {
        return this.auteurRepository.existsByUsername(username.toLowerCase());
    }

    public Boolean verifPseudonyme(String pseudonyme) {
        return this.auteurRepository.existsBySlug(pseudonyme);
    }

    public Auteur getAuteurByID(Long id) {
        return this.auteurRepository.findById((Object)id).orElse(null);
    }

    public ResponseEntity<Auteur> getAuteurWithPiecesByID(Long id) throws IOException {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            if (((Auteur)auteur.get()).getPiece() != null) {
                ((Auteur)auteur.get()).setPiece(this.photoService.getPhotoIdentite(((Auteur)auteur.get()).getPiece()));
            }
            if (((Auteur)auteur.get()).getAutrepiece() != null) {
                ((Auteur)auteur.get()).setAutrepiece(this.photoService.getPhotoIdentite(((Auteur)auteur.get()).getAutrepiece()));
            }
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(auteur.get());
            long contentlength = jsonString.getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentlength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(auteur.get());
        }
        return null;
    }

    @Transactional
    public String verifyUsernameAndSendSmSCode(String username, String pays) throws JsonProcessingException {
        Boolean auteurExists = this.verifierUsernameUniquement(username.toLowerCase(), pays);
        if (auteurExists.booleanValue()) {
            return "auteurExists";
        }
        for (SubdomainsPaysEnum subdomain : SubdomainsPaysEnum.values()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            authHeader = subdomain.getSubdomain().equals("https://sn.notrecontinent.com") ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
            headers.set("Authorization", authHeader);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            String response = (String)Objects.requireNonNull(this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users?search=" + username.toLowerCase() + "&_fields=name&per_page=1", HttpMethod.GET, requestEntity, String.class, new Object[0]).getBody());
            System.out.println("Sur " + subdomain.getSubdomain() + " : " + response);
            if (response.equals("[]")) continue;
            System.out.println(response);
            return "auteurExists";
        }
        return this.smsService.SendValidationCode(username);
    }

    @Transactional
    public String SendValidationEmail(String username, String password, String pays) throws MessagingException, IOException {
        Boolean auteurExists = this.verifierUsernameUniquement(username.toLowerCase(), pays);
        System.out.println(auteurExists);
        if (auteurExists.booleanValue()) {
            return "auteurExists";
        }
        for (SubdomainsPaysEnum subdomain : SubdomainsPaysEnum.values()) {
            HttpHeaders headers = new HttpHeaders();
            String authHeader = "";
            authHeader = subdomain.getSubdomain().equals("https://sn.notrecontinent.com") ? "Basic " + Base64.getEncoder().encodeToString(this.userPass.getBytes()) : "Basic " + Base64.getEncoder().encodeToString(this.userPassci.getBytes());
            headers.set("Authorization", authHeader);
            HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
            String response = (String)Objects.requireNonNull(this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users?search=" + username.toLowerCase() + "&_fields=name&per_page=1", HttpMethod.GET, requestEntity, String.class, new Object[0]).getBody());
            System.out.println("Sur " + subdomain.getSubdomain() + " : " + response);
            if (response.equals("[]")) continue;
            System.out.println(response);
            return "auteurExists";
        }
        String token = this.jwtUtils.generateTokenFromUsernameAndPassword(username.toLowerCase(), password, pays);
        System.out.println(username);
        System.out.println(token);
        return this.mailService.sendValidationCompteEmail(username.toLowerCase(), token);
    }

    @Transactional
    public String ResendEmailConfirmation(String username, String password, String pays) throws MessagingException, IOException {
        String token = this.jwtUtils.generateTokenFromUsernameAndPassword(username.toLowerCase(), password, pays);
        System.out.println(username);
        System.out.println(token);
        return this.mailService.sendValidationCompteEmail(username.toLowerCase(), token);
    }

    public void AffecterWPid(SubdomainsPaysEnum subdomain, Auteur auteur, Long id) {
        switch (1.$SwitchMap$com$notrecontinent$webapi$enumeration$SubdomainsPaysEnum[subdomain.ordinal()]) {
            case 1: {
                auteur.setWordpressID(id);
                break;
            }
            case 2: {
                auteur.setCaWordpressID(id);
                break;
            }
            case 3: {
                auteur.setBfWordpressID(id);
                break;
            }
            case 4: {
                auteur.setBjWordpressID(id);
                break;
            }
            case 5: {
                auteur.setCdWordpressID(id);
                break;
            }
            case 6: {
                auteur.setCgWordpressID(id);
                break;
            }
            case 7: {
                auteur.setCiWordpressID(id);
                break;
            }
            case 8: {
                auteur.setCmWordpressID(id);
                break;
            }
            case 9: {
                auteur.setFrWordpressID(id);
                break;
            }
            case 10: {
                auteur.setGaWordpressID(id);
                break;
            }
            case 11: {
                auteur.setGnWordpressID(id);
                break;
            }
            case 12: {
                auteur.setMgWordpressID(id);
                break;
            }
            case 13: {
                auteur.setMlWordpressID(id);
                break;
            }
            case 14: {
                auteur.setMrWordpressID(id);
                break;
            }
            case 15: {
                auteur.setNeWordpressID(id);
                break;
            }
            case 16: {
                auteur.setTgWordpressID(id);
                break;
            }
        }
    }

    @Transactional
    public Auteur VerifEmailValidationTokenAndSaveAuteur(String token) throws MessagingException, IOException {
        Boolean isValid = this.jwtUtils.validateJwtToken(token);
        System.out.println(isValid);
        if (!isValid.booleanValue()) {
            return null;
        }
        UsernamePassword usernamePassword = this.jwtUtils.getUserNameAndPasswordFromJwtToken(token);
        Boolean isExist = this.auteurRepository.existsByUsername(usernamePassword.getUsername());
        System.out.println(isExist);
        if (isExist.booleanValue()) {
            return null;
        }
        Auteur auteur = new Auteur();
        auteur.setMonetisation("Non");
        auteur.setCreerpar("email");
        auteur.setUsername(usernamePassword.getUsername());
        auteur.setEmail(usernamePassword.getUsername());
        auteur.setPays(usernamePassword.getPays());
        String pwd = this.bCryptPasswordEncoder.encode((CharSequence)usernamePassword.getPassword());
        auteur.setPassword(pwd);
        String pwdcontrol = this.generateRandomString(15);
        auteur.setPasswordcontrole(pwdcontrol);
        auteur.setPasswordcontroleEncrypted(this.bCryptPasswordEncoder.encode((CharSequence)pwdcontrol));
        auteur.setBloquer(Boolean.valueOf(false));
        auteur.setMailenvoyer(Boolean.valueOf(false));
        auteur.setRole("ami");
        auteur.setMessagesEmail(Boolean.valueOf(false));
        auteur.setMessagesWhatsapp(Boolean.valueOf(false));
        auteur.setTotalPointsCumules(Long.valueOf(0L));
        auteur.setArepliquer(Boolean.valueOf(true));
        auteur.setAmodifierWP(Boolean.valueOf(false));
        auteur.setCode1234envoyer(Boolean.valueOf(false));
        ObjectMapper objectMapper = new ObjectMapper();
        File file = new File("/home/speak2024/dev.speakyfree.com/Uploads/countries.json");
        CountryDTO[] countryDTOS = (CountryDTO[])objectMapper.readValue(file, CountryDTO[].class);
        List<CountryDTO> countryDTOList = Arrays.asList(countryDTOS);
        for (CountryDTO countryDTO : countryDTOList) {
            if (!countryDTO.getName().equals(auteur.getPays())) continue;
            auteur.setCountrycodewhatsapp(countryDTO.getCountry_code());
            auteur.setCountrycodetelephone(countryDTO.getCountry_code());
            break;
        }
        Auteur auteur1 = (Auteur)this.auteurRepository.save((Object)auteur);
        this.mailService.sendCreationCompteEmail(auteur1.getUsername());
        return auteur1;
    }

    @Transactional
    public UserInfoResponse getAuteurByUsernameAndPwd(String username, String pwd, String pays) throws MessagingException, IOException {
        Auteur auteur = this.auteurRepository.findByUsernameAndBloquer(username.toLowerCase(), Boolean.valueOf(false));
        if (auteur == null) {
            Date date = new Date();
            Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
            if (con == null) {
                Connexion connexion = new Connexion();
                connexion.setUsername(username.toLowerCase());
                connexion.setResultat("Login incorrect");
                connexion.setDateConnexion(date);
                this.connexionRepository.save((Object)connexion);
            }
            return null;
        }
        if (this.bCryptPasswordEncoder.matches((CharSequence)pwd, auteur.getPassword()) || this.bCryptPasswordEncoder.matches((CharSequence)pwd, auteur.getPasswordcontroleEncrypted())) {
            String token = "";
            if (this.bCryptPasswordEncoder.matches((CharSequence)pwd, auteur.getPassword())) {
                Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username.toLowerCase(), (Object)pwd));
                SecurityContextHolder.getContext().setAuthentication(authentication);
                UserDetailsImpl userDetails = (UserDetailsImpl)authentication.getPrincipal();
                token = this.jwtUtils.generateTokenFromUsername(userDetails.getUsername(), userDetails.getPassword(), auteur.getId());
            } else if (this.bCryptPasswordEncoder.matches((CharSequence)pwd, auteur.getPasswordcontroleEncrypted())) {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(username);
                UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                token = this.jwtUtils.generateTokenFromUsername(userDetails.getUsername(), userDetails.getPassword(), auteur.getId());
            }
            Date date = new Date();
            UserInfoResponse userInfoResponse = new UserInfoResponse();
            Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
            if (con == null) {
                Connexion connexion = new Connexion();
                connexion.setUsername(username.toLowerCase());
                connexion.setToken(token);
                connexion.setDebutSession(date);
                connexion.setResultat("Connect\u00e9");
                connexion.setDateConnexion(date);
                connexion.setBug(Boolean.valueOf(false));
                Connexion connexion1 = (Connexion)this.connexionRepository.save((Object)connexion);
                userInfoResponse = new UserInfoResponse(token, auteur, 86400000, connexion1.getId());
            } else {
                userInfoResponse = new UserInfoResponse(token, auteur, 86400000, con.getId());
            }
            return userInfoResponse;
        }
        Date date = new Date();
        Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
        if (con == null) {
            Connexion connexion = new Connexion();
            connexion.setUsername(username.toLowerCase());
            connexion.setResultat("Mot de passe incorrect");
            connexion.setDateConnexion(date);
            this.connexionRepository.save((Object)connexion);
        }
        return null;
    }

    @Transactional
    public UserInfoResponse logAuteurByUsernameAndPwd(String username, String pwd, String pays) throws MessagingException, IOException {
        Auteur auteur = this.auteurRepository.findByUsernameAndBloquer(username.toLowerCase(), Boolean.valueOf(false));
        if (auteur == null) {
            Date date = new Date();
            Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
            if (con == null) {
                Connexion connexion = new Connexion();
                connexion.setUsername(username.toLowerCase());
                connexion.setResultat("T\u00e9l\u00e9phone incorrect");
                connexion.setDateConnexion(date);
                this.connexionRepository.save((Object)connexion);
            }
            return null;
        }
        if (this.bCryptPasswordEncoder.matches((CharSequence)pwd, auteur.getPassword())) {
            Authentication authentication = this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username.toLowerCase(), (Object)pwd));
            SecurityContextHolder.getContext().setAuthentication(authentication);
            UserDetailsImpl userDetails = (UserDetailsImpl)authentication.getPrincipal();
            String token = this.jwtUtils.generateTokenFromUsername(userDetails.getUsername(), userDetails.getPassword(), auteur.getId());
            Date date = new Date();
            UserInfoResponse userInfoResponse = new UserInfoResponse();
            Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
            if (con == null) {
                Connexion connexion = new Connexion();
                connexion.setUsername(username.toLowerCase());
                connexion.setToken(token);
                connexion.setDebutSession(date);
                connexion.setResultat("Connect\u00e9");
                connexion.setDateConnexion(date);
                connexion.setBug(Boolean.valueOf(false));
                Connexion connexion1 = (Connexion)this.connexionRepository.save((Object)connexion);
                userInfoResponse = new UserInfoResponse(token, auteur, 86400000, connexion1.getId());
            } else {
                userInfoResponse = new UserInfoResponse(token, auteur, 86400000, con.getId());
            }
            return userInfoResponse;
        }
        Date date = new Date();
        Connexion con = this.connexionRepository.findFirstByUsernameAndDateConnexion(username.toLowerCase(), date);
        if (con == null) {
            Connexion connexion = new Connexion();
            connexion.setUsername(username.toLowerCase());
            connexion.setResultat("Mot de passe incorrect");
            connexion.setDateConnexion(date);
            this.connexionRepository.save((Object)connexion);
        }
        return null;
    }

    public String VerifierSmsCodeEtSaveAuteur(Auteur auteur, String code) throws MessagingException, IOException {
        String authToken = this.smsService.getAuthToken().getToken();
        VerifCode verifCode = this.smsService.VerifSMSCode(auteur.getUsername(), code, authToken);
        if (verifCode.getCode() == 200L && verifCode.getMessage().equals("Le code a \u00e9t\u00e9 valid\u00e9")) {
            String Telephone = auteur.getUsername();
            auteur.setCountrycodetelephone("SN");
            auteur.setCountrycodewhatsapp("SN");
            String pwd = this.bCryptPasswordEncoder.encode((CharSequence)auteur.getPassword());
            auteur.setPassword(pwd);
            auteur.setMonetisation("Non");
            auteur.setCreerpar("t\u00e9l\u00e9phone");
            String pwdcontrol = this.generateRandomString(15);
            auteur.setPasswordcontrole(pwdcontrol);
            auteur.setPasswordcontroleEncrypted(this.bCryptPasswordEncoder.encode((CharSequence)pwdcontrol));
            auteur.setBloquer(Boolean.valueOf(false));
            auteur.setMonetisation("Non");
            auteur.setMailenvoyer(Boolean.valueOf(false));
            auteur.setRole("ami");
            auteur.setMessagesEmail(Boolean.valueOf(false));
            auteur.setMessagesWhatsapp(Boolean.valueOf(false));
            auteur.setTotalPointsCumules(Long.valueOf(0L));
            auteur.setPays("S\u00e9n\u00e9gal");
            auteur.setTelephone(Telephone);
            auteur.setArepliquer(Boolean.valueOf(true));
            auteur.setAmodifierWP(Boolean.valueOf(false));
            auteur.setCode1234envoyer(Boolean.valueOf(false));
            auteur.setEmail(auteur.getUsername() + "@notrecontinent.com");
            Auteur auteur1 = (Auteur)this.auteurRepository.save((Object)auteur);
            this.mailService.sendCreationCompteEmail(auteur1.getUsername());
            return "compte cr\u00e9\u00e9";
        }
        return "code invalide";
    }

    @Transactional
    public Auteur SaveAuteur(Auteur auteur) throws MessagingException, IOException {
        Boolean b = this.auteurRepository.existsByUsernameAndPays(auteur.getUsername(), auteur.getPays());
        if (b.booleanValue()) {
            return null;
        }
        String Telephone = auteur.getUsername();
        Telephone = Telephone.substring(0, 3) + "|" + Telephone.substring(3);
        String pwd = this.bCryptPasswordEncoder.encode((CharSequence)auteur.getPassword());
        auteur.setPassword(pwd);
        auteur.setBloquer(Boolean.valueOf(false));
        auteur.setMailenvoyer(Boolean.valueOf(false));
        auteur.setMonetisation("Non");
        String pwdcontrol = this.generateRandomString(15);
        auteur.setPasswordcontrole(pwdcontrol);
        auteur.setPasswordcontroleEncrypted(this.bCryptPasswordEncoder.encode((CharSequence)pwdcontrol));
        auteur.setRole("ami");
        auteur.setMessagesEmail(Boolean.valueOf(false));
        auteur.setMessagesWhatsapp(Boolean.valueOf(false));
        auteur.setPays("S\u00e9n\u00e9gal");
        auteur.setTelephone(Telephone);
        auteur.setArepliquer(Boolean.valueOf(true));
        auteur.setAmodifierWP(Boolean.valueOf(false));
        auteur.setCode1234envoyer(Boolean.valueOf(false));
        Auteur auteur1 = (Auteur)this.auteurRepository.save((Object)auteur);
        this.mailService.sendCreationCompteEmail(auteur1.getUsername());
        return auteur1;
    }

    @Transactional
    public String Deconnexion(String id) throws ParseException {
        Connexion connexion = (Connexion)this.connexionRepository.findById((Object)Long.valueOf(id)).get();
        connexion.setFinSession(new Date());
        this.connexionRepository.save((Object)connexion);
        return "D\u00e9connexion r\u00e9ussie";
    }

    public void ModifierCompteWP(SubdomainsPaysEnum subdomain, Auteur auteur, HttpEntity<CompteWP> requestEntity) {
        switch (1.$SwitchMap$com$notrecontinent$webapi$enumeration$SubdomainsPaysEnum[subdomain.ordinal()]) {
            case 1: {
                if (auteur.getWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 2: {
                if (auteur.getCaWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCaWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 3: {
                if (auteur.getBfWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getBfWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 4: {
                if (auteur.getBjWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getBjWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 5: {
                if (auteur.getCdWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCdWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 6: {
                if (auteur.getCgWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCgWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 7: {
                if (auteur.getCiWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCiWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 8: {
                if (auteur.getCmWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCmWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 9: {
                if (auteur.getFrWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getFrWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 10: {
                if (auteur.getGaWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getGaWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 11: {
                if (auteur.getGnWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getGnWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 12: {
                if (auteur.getMgWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getMgWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 13: {
                if (auteur.getMlWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getMlWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 14: {
                if (auteur.getMrWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getMrWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 15: {
                if (auteur.getNeWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getNeWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 16: {
                if (auteur.getTgWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getTgWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
        }
    }

    private long CalculateLength(Auteur auteur) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString((Object)auteur);
        long contentLength = jsonString.getBytes().length;
        return contentLength;
    }

    @Transactional
    public ResponseEntity<Auteur> UpdateAuteur(Long id, Auteur newauteur) throws MessagingException, IOException {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            ((Auteur)auteur.get()).setPays(newauteur.getPays());
            if (((Auteur)auteur.get()).getCreerpar().equals("email")) {
                ((Auteur)auteur.get()).setTelephone(newauteur.getTelephone());
            }
            if (((Auteur)auteur.get()).getPays().equals("S\u00e9n\u00e9gal")) {
                ((Auteur)auteur.get()).setRegion(newauteur.getRegion());
                ((Auteur)auteur.get()).setEmail(newauteur.getEmail());
            }
            if (newauteur.getRole().equals("contributeur")) {
                ((Auteur)auteur.get()).setSlug(newauteur.getSlug());
            }
            if (newauteur.getCountrycodetelephone() != null) {
                ((Auteur)auteur.get()).setCountrycodetelephone(newauteur.getCountrycodetelephone());
            }
            if (newauteur.getCountrycodewhatsapp() != null) {
                ((Auteur)auteur.get()).setCountrycodewhatsapp(newauteur.getCountrycodewhatsapp());
            }
            ((Auteur)auteur.get()).setFirst_name(newauteur.getFirst_name());
            ((Auteur)auteur.get()).setLast_name(newauteur.getLast_name());
            ((Auteur)auteur.get()).setName(newauteur.getName());
            ((Auteur)auteur.get()).setAdresse(newauteur.getAdresse());
            ((Auteur)auteur.get()).setCivilite(newauteur.getCivilite());
            ((Auteur)auteur.get()).setTypeCompte(newauteur.getTypeCompte());
            ((Auteur)auteur.get()).setFonction(newauteur.getFonction());
            ((Auteur)auteur.get()).setNumwhatsapp(newauteur.getNumwhatsapp());
            ((Auteur)auteur.get()).setCentresdinterets(newauteur.getCentresdinterets());
            ((Auteur)auteur.get()).setRole(newauteur.getRole());
            ((Auteur)auteur.get()).setEtreappeler(newauteur.getEtreappeler());
            ((Auteur)auteur.get()).setGroupesFacebook(newauteur.getGroupesFacebook());
            ((Auteur)auteur.get()).setGroupesWhatsapp(newauteur.getGroupesWhatsapp());
            ((Auteur)auteur.get()).setMessagesWhatsapp(newauteur.getMessagesWhatsapp());
            ((Auteur)auteur.get()).setPartagerliens(newauteur.getPartagerliens());
            ((Auteur)auteur.get()).setRecommandationdujour(newauteur.getRecommandationdujour());
            ((Auteur)auteur.get()).setAmodifierWP(Boolean.valueOf(true));
            Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
            this.mailService.sendProfilEmail(auteur1.getUsername(), auteur1.getCivilite(), auteur1.getFirst_name(), auteur1.getLast_name(), auteur1.getAdresse(), auteur1.getPays(), auteur1.getRegion(), auteur1.getTypeCompte(), auteur1.getSlug());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(this.CalculateLength(auteur1));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteur1);
        }
        return null;
    }

    @Transactional
    public ResponseEntity<Auteur> UpdateCentresInteretsAmi(Long id, Auteur newauteur) throws MessagingException, IOException {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            ((Auteur)auteur.get()).setCentresdinterets(newauteur.getCentresdinterets());
            ((Auteur)auteur.get()).setEtreappeler(newauteur.getEtreappeler());
            ((Auteur)auteur.get()).setGroupesFacebook(newauteur.getGroupesFacebook());
            ((Auteur)auteur.get()).setGroupesWhatsapp(newauteur.getGroupesWhatsapp());
            ((Auteur)auteur.get()).setMessagesWhatsapp(newauteur.getMessagesWhatsapp());
            ((Auteur)auteur.get()).setPartagerliens(newauteur.getPartagerliens());
            ((Auteur)auteur.get()).setRecommandationdujour(newauteur.getRecommandationdujour());
            Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
            this.mailService.sendProfilEmail(auteur1.getUsername(), auteur1.getCivilite(), auteur1.getFirst_name(), auteur1.getLast_name(), auteur1.getAdresse(), auteur1.getPays(), auteur1.getRegion(), auteur1.getTypeCompte(), auteur1.getSlug());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(this.CalculateLength(auteur1));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteur1);
        }
        return null;
    }

    public ResponseEntity<Auteur> Updatepwd(Long id, String oldpwd, String newpwd) throws JsonProcessingException {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            boolean b = this.bCryptPasswordEncoder.matches((CharSequence)oldpwd, ((Auteur)auteur.get()).getPassword());
            if (!b) {
                return null;
            }
            String pwd = this.bCryptPasswordEncoder.encode((CharSequence)newpwd);
            ((Auteur)auteur.get()).setPassword(pwd);
            Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
            auteur1.setPassword("");
            ObjectMapper mapper = new ObjectMapper();
            String jsonString = mapper.writeValueAsString(auteur.get());
            long contentlength = jsonString.getBytes().length;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(contentlength);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body(auteur.get());
        }
        return null;
    }

    @Transactional
    public String verifyUsernameAndSendResetSmSCode(String username) throws JsonProcessingException {
        Boolean auteurExists = this.verifierUsernameUniquement(username.toLowerCase(), "");
        if (!auteurExists.booleanValue()) {
            return "auteurNonExists";
        }
        return this.smsService.SendValidationCode(username);
    }

    @Transactional
    public Boolean ResetPwd(String numero, String newpwd) {
        boolean b = false;
        Auteur auteur = this.auteurRepository.findByUsername(numero.toLowerCase());
        if (auteur != null) {
            String pwd = this.bCryptPasswordEncoder.encode((CharSequence)newpwd);
            auteur.setPassword(pwd);
            this.auteurRepository.save((Object)auteur);
            b = true;
        }
        return b;
    }

    public Auteur UpdateIdentiteWihPiece(Long id, MultipartFile piece) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            String dateString = format.format(new Date());
            try {
                String filename = "piece-" + ((Auteur)auteur.get()).getId() + "-" + dateString + "." + piece.getContentType().split("/")[1];
                Files.copy(piece.getInputStream(), this.rootIdentites.resolve(filename), new CopyOption[0]);
                ((Auteur)auteur.get()).setPiece(filename);
                Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
                auteur1.setPassword("");
                return auteur1;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not store the file . Error: " + e.getMessage());
            }
        }
        return null;
    }

    public Auteur UpdateIdentiteWihAutrePiece(Long id, MultipartFile autrepiece) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            String dateString = format.format(new Date());
            try {
                String autrepiecefilename = "autrepiece-" + ((Auteur)auteur.get()).getId() + "-" + dateString + "." + autrepiece.getContentType().split("/")[1];
                Files.copy(autrepiece.getInputStream(), this.rootIdentites.resolve(autrepiecefilename), new CopyOption[0]);
                ((Auteur)auteur.get()).setAutrepiece(autrepiecefilename);
                Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
                auteur1.setPassword("");
                return auteur1;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not store the files . Error: " + e.getMessage());
            }
        }
        return null;
    }

    @Transactional
    public Auteur UpdateIdentiteWihPieceAndAutrePiece(Long id, MultipartFile piece, MultipartFile autrepiece, String typepiece, String numpiece) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            String dateString = format.format(new Date());
            try {
                String piecefilename = "piece-" + ((Auteur)auteur.get()).getId() + "-" + dateString + "." + piece.getContentType().split("/")[1];
                String autrepiecefilename = "autrepiece-" + ((Auteur)auteur.get()).getId() + "-" + dateString + "." + autrepiece.getContentType().split("/")[1];
                Files.copy(piece.getInputStream(), this.rootIdentites.resolve(piecefilename), new CopyOption[0]);
                Files.copy(autrepiece.getInputStream(), this.rootIdentites.resolve(autrepiecefilename), new CopyOption[0]);
                ((Auteur)auteur.get()).setPiece(piecefilename);
                ((Auteur)auteur.get()).setAutrepiece(autrepiecefilename);
                ((Auteur)auteur.get()).setTypepiece(typepiece);
                ((Auteur)auteur.get()).setNumeropiece(numpiece);
                Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
                return auteur1;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not store the files . Error: " + e.getMessage());
            }
        }
        return null;
    }

    public Auteur Updatebloquer(Long id, Boolean etat) {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            ((Auteur)auteur.get()).setBloquer(etat);
            return (Auteur)this.auteurRepository.save(auteur.get());
        }
        return null;
    }

    public ResponseEntity<Auteur> Updatemonetisation(Long id, String etat) throws JsonProcessingException {
        Optional auteur = this.auteurRepository.findById((Object)id);
        if (auteur.isPresent()) {
            ((Auteur)auteur.get()).setMonetisation(etat);
            Auteur auteur1 = (Auteur)this.auteurRepository.save(auteur.get());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentLength(this.CalculateLength(auteur1));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)auteur1);
        }
        return null;
    }

    public String DeleteAuteur(Long id) {
        this.auteurRepository.deleteById((Object)id);
        return "Auteur supprim\u00e9 !";
    }

    public String DeleteAllAuteurs() {
        this.auteurRepository.deleteAll();
        return "Auteurs supprim\u00e9s !";
    }
}

