/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.LesDTOs.NotificationSmsStatus;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.NotificationSms;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ConnexionRepository;
import com.notrecontinent.webapi.repositories.ModePaiementRepository;
import com.notrecontinent.webapi.repositories.NotificationSmsRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.TransactionRepository;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.SmsService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NotificationSmsService {
    @Autowired
    private NotificationSmsRepository notificationSmsRepository;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private SmsService smsService;
    @Autowired
    private BugsCronService bugsCronService;
    @Value(value="${parametre.lien.sms}")
    private Long param;
    @Autowired
    private ConnexionRepository connexionRepository;
    @Autowired
    private TransactionRepository transactionRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private ModePaiementRepository modePaiementRepository;

    @Transactional
    public void SelectionnerNotificationsSms() {
        try {
            LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
            LocalDateTime datedebut = currentDate.withYear(2024).withMonth(2).withDayOfMonth(10).withHour(0).withMinute(0).withSecond(0);
            Date datededebut = Date.from(datedebut.atZone(ZoneId.of("GMT")).toInstant());
            List amisSms = this.auteurRepository.findAmiSms(datededebut);
            if (!amisSms.isEmpty() && !(amisSms = amisSms.stream().filter(a -> a.getUsername().startsWith("221")).collect(Collectors.toList())).isEmpty()) {
                ArrayList<NotificationSms> notificationSmsList = new ArrayList<NotificationSms>();
                for (Auteur ami : amisSms) {
                    NotificationSms notificationSms = new NotificationSms();
                    notificationSms.setAmiid(ami.getId());
                    notificationSms.setEstenvoyer(Boolean.valueOf(false));
                    notificationSms.setNomami(ami.getFirst_name());
                    notificationSms.setNumero(ami.getUsername());
                    NotificationSms notificationSms1 = this.notificationSmsRepository.findByParametrelien(String.valueOf(this.param));
                    if (notificationSms1 != null) {
                        NotificationSms notificationSms2 = this.notificationSmsRepository.findFirstByOrderByIdDesc();
                        this.param = Long.parseLong(notificationSms2.getParametrelien()) + 1L;
                    }
                    String parametre = String.valueOf(this.param);
                    notificationSms.setParametrelien(parametre);
                    this.param = this.param + 1L;
                    notificationSmsList.add(notificationSms);
                }
                this.notificationSmsRepository.saveAll(notificationSmsList);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de s\u00e9lection des notifications sms pour compte ami sans email", e.getMessage());
        }
    }

    @Transactional
    public void EnvoyerNotificationAmiSms() {
        try {
            List notificationSmsList = this.notificationSmsRepository.findByEstenvoyer(Boolean.valueOf(false));
            if (!notificationSmsList.isEmpty()) {
                for (NotificationSms notificationSms : notificationSmsList) {
                    NotificationSmsStatus notificationSmsStatus = this.smsService.SendNotificationAmi(notificationSms.getNumero(), notificationSms.getNomami(), notificationSms.getParametrelien());
                    if (!notificationSmsStatus.getMessage().equals("success") || !notificationSmsStatus.getCode().equals(200L)) continue;
                    notificationSms.setStatus(notificationSmsStatus.getStatus());
                    notificationSms.setSms_id(notificationSmsStatus.getSms_id());
                    notificationSms.setDateenvoi(new Date());
                    notificationSms.setEstenvoyer(Boolean.valueOf(true));
                    LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
                    LocalDateTime currentdateplus10min = currentDate.plusHours(22L);
                    Date dateexpiration = Date.from(currentdateplus10min.atZone(ZoneId.of("GMT")).toInstant());
                    notificationSms.setDateexpiration(dateexpiration);
                }
                this.notificationSmsRepository.saveAll((Iterable)notificationSmsList);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron d'envoi des notifications sms pour compte ami sans email", e.getMessage());
        }
    }
}

