/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.services;

import com.notrecontinent.webapi.LesDTOs.CompteWP;
import com.notrecontinent.webapi.LesDTOs.VerifCompteDTO;
import com.notrecontinent.webapi.config.UrlConfig;
import com.notrecontinent.webapi.dto.CompteWordpress;
import com.notrecontinent.webapi.entities.AlerteBlocageProfil;
import com.notrecontinent.webapi.entities.AlertesEtreAppeler;
import com.notrecontinent.webapi.entities.Auteur;
import com.notrecontinent.webapi.entities.ModePaiement;
import com.notrecontinent.webapi.entities.MonCompte;
import com.notrecontinent.webapi.enumeration.SubdomainsPaysEnum;
import com.notrecontinent.webapi.mapstruct.DesinscriptionEmailMapper;
import com.notrecontinent.webapi.mapstruct.MonCompteMapper;
import com.notrecontinent.webapi.repositories.AlerteBlocageProfilRepository;
import com.notrecontinent.webapi.repositories.AlertesEtreAppelerRepository;
import com.notrecontinent.webapi.repositories.ArticleRepository;
import com.notrecontinent.webapi.repositories.AuteurRepository;
import com.notrecontinent.webapi.repositories.ComptesLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.ConnexionRepository;
import com.notrecontinent.webapi.repositories.CreationResetCompteRepository;
import com.notrecontinent.webapi.repositories.DesinscriptionEmailRepository;
import com.notrecontinent.webapi.repositories.FusionCompteWPSpeakyRepository;
import com.notrecontinent.webapi.repositories.ModePaiementRepository;
import com.notrecontinent.webapi.repositories.MonCompteRepository;
import com.notrecontinent.webapi.repositories.PointLienPrivilegeRepository;
import com.notrecontinent.webapi.repositories.PointsAmiRepository;
import com.notrecontinent.webapi.repositories.PointsContributeurRepository;
import com.notrecontinent.webapi.repositories.RecommandationAunAmiRepository;
import com.notrecontinent.webapi.repositories.RecommandationRepository;
import com.notrecontinent.webapi.repositories.TransactionRepository;
import com.notrecontinent.webapi.services.AuteurService;
import com.notrecontinent.webapi.services.BugService;
import com.notrecontinent.webapi.services.BugsCronService;
import com.notrecontinent.webapi.services.CodeWhatsappService;
import com.notrecontinent.webapi.services.MailService;
import com.notrecontinent.webapi.services.MissionService;
import com.notrecontinent.webapi.services.PhotoService;
import com.notrecontinent.webapi.services.SmsService;
import com.notrecontinent.webapi.services.WhatsappService;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.mail.MessagingException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AuteurService {
    private final Path rootIdentites = UrlConfig.rootIdentites;
    private final String fusionBDDFilePath = "/home/speak2024/dev.speakyfree.com/SpringBoot/Fusion_BDD_GLOBAL_WP_DEV_SPEAKY_comptes_traites_ok_08_04_2024.csv";
    private final String dateFormat = "dd-MM-yyyy HH:mm:ss";
    @Value(value="${parametre.matricule}")
    private Long matricule;
    @Autowired
    private PhotoService photoService;
    @Autowired
    private MailService mailService;
    @Autowired
    private AuteurRepository auteurRepository;
    @Autowired
    private ConnexionRepository connexionRepository;
    @Autowired
    private ArticleRepository articleRepository;
    @Autowired
    private PointsAmiRepository pointsAmiRepository;
    @Autowired
    private ComptesLienPrivilegeRepository comptesLienPrivilegeRepository;
    @Autowired
    private PointsContributeurRepository pointsContributeurRepository;
    @Autowired
    private BCryptPasswordEncoder bCryptPasswordEncoder;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private BugsCronService bugsCronService;
    @Autowired
    private SmsService smsService;
    @Autowired
    private WhatsappService whatsappService;
    @Autowired
    private RecommandationRepository recommandationRepository;
    @Autowired
    private RecommandationAunAmiRepository recommandationAunAmiRepository;
    @Autowired
    private FusionCompteWPSpeakyRepository fusionCompteWPSpeakyRepository;
    @Autowired
    private MonCompteMapper monCompteMapper;
    @Autowired
    private MonCompteRepository monCompteRepository;
    @Autowired
    private AlertesEtreAppelerRepository alertesEtreAppelerRepository;
    @Autowired
    private ModePaiementRepository modePaiementRepository;
    @Autowired
    private AlerteBlocageProfilRepository alerteBlocageProfilRepository;
    @Autowired
    private TransactionRepository transactionRepository;
    @Autowired
    private BugService bugService;
    @Autowired
    private MissionService missionService;
    @Autowired
    private PointLienPrivilegeRepository pointLienPrivilegeRepository;
    @Autowired
    private CodeWhatsappService codeWhatsappService;
    @Autowired
    private DesinscriptionEmailMapper desinscriptionEmailMapper;
    @Autowired
    private DesinscriptionEmailRepository desinscriptionEmailRepository;
    @Autowired
    private CreationResetCompteRepository creationResetCompteRepository;
    final String userPassci = "Momar:Enpc kRrN iRmm scP5 rvzs Muul";
    final String userPass = "Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5";

    private String generateMatricule() {
        String nummatricule = "NC" + this.matricule;
        this.matricule = this.matricule + 1L;
        return nummatricule;
    }

    @Transactional
    @Scheduled(cron="20 37 12 * * *", zone="GMT")
    public void updateMatriculeComptes() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("ami");
        roles.add("contributeur");
        List auteurs = this.auteurRepository.findByMatriculeIsNullAndRoleIn(roles);
        if (!auteurs.isEmpty()) {
            Auteur auteur = this.auteurRepository.findFirstByParamMatriculeIsNotNullOrderByParamMatriculeDesc();
            if (auteur != null) {
                this.matricule = auteur.getParamMatricule() + 1L;
            }
            for (Auteur a : auteurs) {
                if (a.getMatricule() != null) continue;
                a.setParamMatricule(this.matricule);
                a.setMatricule(this.generateMatricule());
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
        auteurs = null;
    }

    @Transactional
    @Scheduled(cron="7 13 10 * * *", zone="GMT")
    public void MAJmoncompte() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("ami");
        roles.add("contributeur");
        List auteurs = this.auteurRepository.findByRoleIn(roles);
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                try {
                    MonCompte monCompte = this.monCompteRepository.findByAuteurid(auteur.getId());
                    if (monCompte != null) {
                        if (auteur.getMonetisation() != null) {
                            if (auteur.getMonetisation().equals("Oui")) {
                                monCompte.setMonetisation(Boolean.valueOf(true));
                                monCompte.setDesactiverCompte(Boolean.valueOf(false));
                            } else if (auteur.getMonetisation().equals("Non")) {
                                monCompte.setMonetisation(Boolean.valueOf(false));
                            }
                        }
                        if (auteur.getEtreappeler() != null) {
                            monCompte.setEtreAppele(auteur.getEtreappeler());
                            if (auteur.getEtreappeler().booleanValue()) {
                                monCompte.setDesactiverCompte(Boolean.valueOf(false));
                            }
                        }
                        if (auteur.getMessagesEmail() != null) {
                            monCompte.setMessagesEmail(auteur.getMessagesEmail());
                            if (auteur.getMessagesEmail().booleanValue() && auteur.getRole().equals("ami")) {
                                monCompte.setDesactiverCompte(Boolean.valueOf(false));
                            }
                        }
                        if (auteur.getMessagesWhatsapp() != null) {
                            monCompte.setMessagesWhatsapp(auteur.getMessagesWhatsapp());
                            if (auteur.getMessagesWhatsapp().booleanValue() && auteur.getRole().equals("ami")) {
                                monCompte.setDesactiverCompte(Boolean.valueOf(false));
                            }
                        }
                        if (auteur.getRecommandationdujour() != null) {
                            monCompte.setRecomjoursms(auteur.getRecommandationdujour());
                            if (auteur.getRecommandationdujour().booleanValue() && auteur.getRole().equals("ami")) {
                                monCompte.setDesactiverCompte(Boolean.valueOf(false));
                            }
                        }
                        if (monCompte.getDesactiverPaiementEnCours() == null || !monCompte.getDesactiverPaiementEnCours().booleanValue()) {
                            monCompte.setDesactiverPaiementEnCours(Boolean.valueOf(false));
                            monCompte.setDesactiverCompte(Boolean.valueOf(false));
                        }
                        if (auteur.getRole().equals("contributeur")) {
                            if (monCompte.getMonetisation() != null && !monCompte.getMonetisation().booleanValue() && monCompte.getDesactiverPaiementEnCours().booleanValue() && !monCompte.getEtreAppele().booleanValue()) {
                                monCompte.setDesactiverCompte(Boolean.valueOf(true));
                            }
                        } else if (!(!auteur.getRole().equals("ami") || monCompte.getMonetisation() == null || monCompte.getMonetisation().booleanValue() || !monCompte.getDesactiverPaiementEnCours().booleanValue() || monCompte.getMessagesEmail().booleanValue() || monCompte.getMessagesWhatsapp().booleanValue() || monCompte.getRecomjoursms().booleanValue() || monCompte.getEtreAppele().booleanValue())) {
                            monCompte.setDesactiverCompte(Boolean.valueOf(true));
                        }
                        this.monCompteRepository.save((Object)monCompte);
                        continue;
                    }
                    MonCompte monCompte1 = new MonCompte();
                    if (auteur.getMonetisation() != null) {
                        if (auteur.getMonetisation().equals("Oui")) {
                            monCompte1.setMonetisation(Boolean.valueOf(true));
                            monCompte1.setDesactiverCompte(Boolean.valueOf(false));
                        } else if (auteur.getMonetisation().equals("Non")) {
                            monCompte1.setMonetisation(Boolean.valueOf(false));
                        }
                    }
                    if (auteur.getEtreappeler() != null) {
                        monCompte1.setEtreAppele(auteur.getEtreappeler());
                        if (auteur.getEtreappeler().booleanValue()) {
                            monCompte1.setDesactiverCompte(Boolean.valueOf(false));
                        }
                    }
                    if (auteur.getMessagesEmail() != null) {
                        monCompte1.setMessagesEmail(auteur.getMessagesEmail());
                        if (auteur.getMessagesEmail().booleanValue() && auteur.getRole().equals("ami")) {
                            monCompte1.setDesactiverCompte(Boolean.valueOf(false));
                        }
                    }
                    if (auteur.getMessagesWhatsapp() != null) {
                        monCompte1.setMessagesWhatsapp(auteur.getMessagesWhatsapp());
                        if (auteur.getMessagesWhatsapp().booleanValue() && auteur.getRole().equals("ami")) {
                            monCompte1.setDesactiverCompte(Boolean.valueOf(false));
                        }
                    }
                    if (auteur.getRecommandationdujour() != null) {
                        monCompte1.setRecomjoursms(auteur.getRecommandationdujour());
                        if (auteur.getRecommandationdujour().booleanValue() && auteur.getRole().equals("ami")) {
                            monCompte1.setDesactiverCompte(Boolean.valueOf(false));
                        }
                    }
                    if (monCompte1.getDesactiverPaiementEnCours() == null || !monCompte1.getDesactiverPaiementEnCours().booleanValue()) {
                        monCompte1.setDesactiverPaiementEnCours(Boolean.valueOf(false));
                        monCompte1.setDesactiverCompte(Boolean.valueOf(false));
                    }
                    if (auteur.getRole().equals("contributeur")) {
                        if (monCompte1.getMonetisation() != null && !monCompte1.getMonetisation().booleanValue() && monCompte1.getDesactiverPaiementEnCours().booleanValue() && !monCompte1.getEtreAppele().booleanValue()) {
                            monCompte1.setDesactiverCompte(Boolean.valueOf(true));
                        }
                    } else if (!(!auteur.getRole().equals("ami") || monCompte1.getMonetisation() == null || monCompte1.getMonetisation().booleanValue() || !monCompte1.getDesactiverPaiementEnCours().booleanValue() || monCompte1.getMessagesEmail().booleanValue() || monCompte1.getMessagesWhatsapp().booleanValue() || monCompte1.getRecomjoursms().booleanValue() || monCompte1.getEtreAppele().booleanValue())) {
                        monCompte1.setDesactiverCompte(Boolean.valueOf(true));
                    }
                    monCompte1.setAuteurid(auteur.getId());
                    this.monCompteRepository.save((Object)monCompte1);
                }
                catch (Exception e) {
                    System.out.println("----------------------------------------------------");
                    System.out.println("Message du bug");
                    System.out.println(e.getMessage());
                    System.out.println("----------------------------------------------------");
                    this.bugsCronService.SaveBugCron("MAJ de Mon Compte pour le compte" + auteur.getUsername(), e.getMessage());
                }
            }
        }
    }

    @Scheduled(cron="7 */11 * * * *", zone="GMT")
    @Transactional
    public void UpdateAuteursToWP() {
        try {
            List auteurList = this.auteurRepository.findByAmodifierWP(Boolean.valueOf(true));
            if (!auteurList.isEmpty()) {
                for (Auteur auteur : auteurList) {
                    String email;
                    CompteWP compte = new CompteWP();
                    compte.setFirst_name(auteur.getFirst_name());
                    compte.setLast_name(auteur.getLast_name());
                    compte.setName(auteur.getName());
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    if (auteur.getEmail() != null) {
                        email = "PL-" + simpleDateFormat.format(auteur.getDateCreation()) + "-" + auteur.getEmail();
                        compte.setEmail(email);
                    } else if (auteur.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                        email = "PL-" + simpleDateFormat.format(auteur.getDateCreation()) + "-" + auteur.getUsername() + "@notrecontinent.com";
                        compte.setEmail(email);
                    }
                    HttpHeaders header = new HttpHeaders();
                    String authHeader = "Basic " + Base64.getEncoder().encodeToString("Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5".getBytes());
                    header.set("Authorization", authHeader);
                    HttpEntity requestEntity = new HttpEntity((Object)compte, (MultiValueMap)header);
                    try {
                        String response1 = (String)this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/users/" + auteur.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                        auteur.setAmodifierWP(Boolean.valueOf(false));
                    }
                    catch (Exception e) {
                        System.out.println("----------------------------------------------------");
                        System.out.println("Message du bug");
                        System.out.println(e.getMessage());
                        System.out.println("----------------------------------------------------");
                        this.bugsCronService.SaveBugCron("Modification du profil du compte" + auteur.getUsername() + " dans Wordpress", e.getMessage());
                    }
                }
                this.auteurRepository.saveAll((Iterable)auteurList);
            }
        }
        catch (Exception e) {
            System.out.println("----------------------------------------------------");
            System.out.println("Message du bug");
            System.out.println(e.getMessage());
            System.out.println("----------------------------------------------------");
            this.bugsCronService.SaveBugCron("Cron de modification du profil d'un compte dans Wordpress", e.getMessage());
        }
    }

    @Transactional
    @Scheduled(cron="0 */2 * * * *", zone="GMT")
    public void RepliquerComptesSnWordpress() {
        List auteurs = this.auteurRepository.findByArepliquer(Boolean.valueOf(true));
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                HttpHeaders headers = new HttpHeaders();
                String authHeader = "Basic " + Base64.getEncoder().encodeToString("Momar:MnQm 5IUf aIZb 9Ekj LQog T6y5".getBytes());
                String authHeaderci = "Basic " + Base64.getEncoder().encodeToString("Momar:Enpc kRrN iRmm scP5 rvzs Muul".getBytes());
                headers.set("Authorization", authHeader);
                HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                HttpHeaders headers1 = new HttpHeaders();
                headers1.set("Authorization", authHeaderci);
                CompteWordpress compteWordpress = new CompteWordpress();
                String email = "PL-" + sdf.format(auteur.getDateCreation()) + "-" + auteur.getUsername();
                if (auteur.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    email = email + "@notrecontinent.com";
                }
                compteWordpress.setEmail(email);
                compteWordpress.setUsername(auteur.getUsername());
                compteWordpress.setPassword(auteur.getPassword());
                HttpEntity compteWordpressHttpEntity = new HttpEntity((Object)compteWordpress, (MultiValueMap)headers);
                try {
                    CompteWordpress compteWordpress1 = (CompteWordpress)this.restTemplate.exchange("https://sn.notrecontinent.com/wp-json/wp/v2/users", HttpMethod.POST, compteWordpressHttpEntity, CompteWordpress.class, new Object[0]).getBody();
                    auteur.setWordpressID(compteWordpress1.getId());
                    auteur.setArepliquer(Boolean.valueOf(false));
                }
                catch (Exception e) {
                    System.out.println("Compte : " + auteur.getUsername());
                    System.out.println("Back office  : https://sn.notrecontinent.com/wp-json/wp/v2/users");
                    System.out.println(e.getMessage());
                    this.bugsCronService.SaveBugCron("r\u00e9plication du compte " + auteur.getUsername() + " vers le back office Wordpress SN", e.getMessage());
                }
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
    }

    @Transactional
    @Scheduled(cron="10 4 * * * *", zone="GMT")
    public void RepliquerComptesAutresWordpress() {
        List auteurs = this.auteurRepository.findByArepliquerAndRole(Boolean.valueOf(false), "contributeur");
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                Boolean b = auteur.getWordpressID() != null && auteur.getBjWordpressID() == null && auteur.getBfWordpressID() == null && auteur.getCiWordpressID() == null && auteur.getGnWordpressID() == null && auteur.getMlWordpressID() == null && auteur.getNeWordpressID() == null && auteur.getTgWordpressID() == null && auteur.getCdWordpressID() == null && auteur.getCmWordpressID() == null && auteur.getGaWordpressID() == null && auteur.getMrWordpressID() == null && auteur.getCgWordpressID() == null && auteur.getMgWordpressID() == null && auteur.getFrWordpressID() == null && auteur.getCaWordpressID() == null;
                if (!b.booleanValue()) continue;
                String authHeaderci = "Basic " + Base64.getEncoder().encodeToString("Momar:Enpc kRrN iRmm scP5 rvzs Muul".getBytes());
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
                HttpHeaders headers1 = new HttpHeaders();
                headers1.set("Authorization", authHeaderci);
                CompteWordpress compteWordpress = new CompteWordpress();
                String email = "PL-" + sdf.format(auteur.getDateCreation()) + "-" + auteur.getUsername();
                if (auteur.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    email = email + "@notrecontinent.com";
                }
                compteWordpress.setEmail(email);
                compteWordpress.setUsername(auteur.getUsername());
                compteWordpress.setPassword(auteur.getPassword());
                for (SubdomainsPaysEnum subdomain : SubdomainsPaysEnum.values()) {
                    if (subdomain.getSubdomain().equals("https://sn.notrecontinent.com")) continue;
                    HttpEntity compteWordpressHttpEntity = new HttpEntity((Object)compteWordpress, (MultiValueMap)headers1);
                    System.out.println(subdomain.getSubdomain());
                    try {
                        CompteWordpress compteWordpress1 = (CompteWordpress)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users", HttpMethod.POST, compteWordpressHttpEntity, CompteWordpress.class, new Object[0]).getBody();
                        this.AffecterWPid(subdomain, auteur, compteWordpress1.getId());
                    }
                    catch (Exception e) {
                        System.out.println("Compte : " + auteur.getUsername());
                        System.out.println("Back office  : " + subdomain.getSubdomain());
                        System.out.println(e.getMessage());
                        this.bugsCronService.SaveBugCron("r\u00e9plication du compte " + auteur.getUsername() + " vers " + subdomain.getSubdomain(), e.getMessage());
                    }
                }
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
    }

    @Transactional
    @Scheduled(cron="0 3 10 * * *")
    public void genererPasswordControle() {
        List auteurs = this.auteurRepository.findByRoleNot("admin");
        if (!auteurs.isEmpty()) {
            for (Auteur auteur : auteurs) {
                String pwdcontrol = this.generateRandomString(15);
                auteur.setPasswordcontrole(pwdcontrol);
                auteur.setPasswordcontroleEncrypted(this.bCryptPasswordEncoder.encode((CharSequence)pwdcontrol));
            }
            this.auteurRepository.saveAll((Iterable)auteurs);
        }
    }

    @Transactional
    public void SelectAlertesEtreAppeler() {
        List auteurList = this.auteurRepository.findByRoleAndEtreappeler("ami", Boolean.valueOf(true));
        if (!auteurList.isEmpty()) {
            ArrayList<AlertesEtreAppeler> alertesEtreAppelerList = new ArrayList<AlertesEtreAppeler>();
            for (Auteur a : auteurList) {
                Boolean b = this.alertesEtreAppelerRepository.existsByAmiid(a.getId());
                if (b.booleanValue()) continue;
                AlertesEtreAppeler alertesEtreAppeler = new AlertesEtreAppeler();
                alertesEtreAppeler.setAmiid(a.getId());
                alertesEtreAppeler.setName(a.getName());
                if (a.getCreerpar().equals("email")) {
                    alertesEtreAppeler.setContact(a.getTelephone());
                } else if (a.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    alertesEtreAppeler.setContact(a.getUsername());
                }
                alertesEtreAppeler.setTotalpoints(a.getTotalPointsCumules());
                if (!a.getNumwhatsapp().equals("") && a.getNumwhatsapp() != null && a.getCode1234envoyer().booleanValue()) {
                    alertesEtreAppeler.setNumwhatsapp(a.getNumwhatsapp());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                alertesEtreAppeler.setDatedecreation(sdf.format(a.getDateCreation()));
                alertesEtreAppeler.setUsername(a.getUsername());
                alertesEtreAppeler.setPays(a.getPays());
                alertesEtreAppeler.setEstenvoyer(Boolean.valueOf(false));
                alertesEtreAppelerList.add(alertesEtreAppeler);
            }
            if (!alertesEtreAppelerList.isEmpty()) {
                this.alertesEtreAppelerRepository.saveAll(alertesEtreAppelerList);
            }
        }
    }

    @Transactional
    public void SendAlertesEtreAppeler() throws MessagingException, UnsupportedEncodingException {
        List alertesEtreAppelerList = this.alertesEtreAppelerRepository.findByEstenvoyer(Boolean.valueOf(false));
        if (!alertesEtreAppelerList.isEmpty()) {
            this.mailService.SendAlerteEtreAppeler(alertesEtreAppelerList);
            for (AlertesEtreAppeler a : alertesEtreAppelerList) {
                a.setEstenvoyer(Boolean.valueOf(true));
            }
        }
    }

    @Transactional
    public void SelectProfilStep2Incomplets() {
        LocalDateTime currentDatemoins30min;
        Date dateactuellemoins30min;
        LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime currentDatesince30avril2024 = currentDate.withYear(2024).withMonth(4).withDayOfMonth(30).withHour(0).withMinute(0).withSecond(0);
        Date dateactuellesince30avril2024 = Date.from(currentDatesince30avril2024.atZone(ZoneId.of("GMT")).toInstant());
        List auteurs = this.auteurRepository.findAuteursIncomplets(dateactuellesince30avril2024, dateactuellemoins30min = Date.from((currentDatemoins30min = currentDate.minusMinutes(30L)).atZone(ZoneId.of("GMT")).toInstant()));
        if (!auteurs.isEmpty()) {
            ArrayList<AlerteBlocageProfil> blocageProfilList = new ArrayList<AlerteBlocageProfil>();
            for (Auteur a : auteurs) {
                Boolean b;
                Date dateactuelle = Date.from(currentDate.atZone(ZoneId.of("GMT")).toInstant());
                Boolean datemodifis30minbeforenow = (dateactuelle.getTime() - a.getDateModification().getTime()) / 60000L >= 30L;
                if (!datemodifis30minbeforenow.booleanValue() || !(b = Boolean.valueOf(a.getName() == null || a.getFirst_name() == null || a.getLast_name() == null || a.getCivilite() == null || a.getAdresse() == null || a.getPays().equals("S\u00e9n\u00e9gal") && a.getRegion() == null || !a.getPays().equals("S\u00e9n\u00e9gal") && a.getVille() == null || a.getTypeCompte() == null || a.getRole().equals("contributeur") && a.getSlug() == null || a.getCreerpar().equals("email") && a.getTelephone() == null || a.getPays() == null)).booleanValue()) continue;
                AlerteBlocageProfil alerteBlocageProfil = new AlerteBlocageProfil();
                if (a.getCreerpar().equals("email")) {
                    alerteBlocageProfil.setCompte(a.getTelephone());
                } else if (a.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    alerteBlocageProfil.setCompte(a.getUsername());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                alerteBlocageProfil.setDatedecreation(sdf.format(a.getDateCreation()));
                alerteBlocageProfil.setTotalpoints(a.getTotalPointsCumules());
                alerteBlocageProfil.setTypecompte(a.getRole());
                alerteBlocageProfil.setIdcompte(a.getId());
                alerteBlocageProfil.setObjet("Blocage \u00e0 l'\u00e9tape de renseignement des informations personnelles");
                alerteBlocageProfil.setEstenvoyer(Boolean.valueOf(false));
                alerteBlocageProfil.setNamecompte(a.getName());
                alerteBlocageProfil.setUsername(a.getUsername());
                if (a.getRole().equals("ami") && a.getNumwhatsapp() != null && !a.getNumwhatsapp().equals("") && a.getCode1234envoyer().booleanValue()) {
                    alerteBlocageProfil.setNumwhatsapp(a.getNumwhatsapp());
                }
                alerteBlocageProfil.setPays(a.getPays());
                blocageProfilList.add(alerteBlocageProfil);
            }
            if (!blocageProfilList.isEmpty()) {
                this.alerteBlocageProfilRepository.saveAll(blocageProfilList);
            }
        }
    }

    @Transactional
    public void SendProfilStep2Incomplets() throws MessagingException, UnsupportedEncodingException {
        List blocageProfilList = this.alerteBlocageProfilRepository.findByEstenvoyerAndObjet(Boolean.valueOf(false), "Blocage \u00e0 l'\u00e9tape de renseignement des informations personnelles");
        if (!blocageProfilList.isEmpty()) {
            List alerteBlocageProfils = this.mailService.sendAlertProfilIncomplets(blocageProfilList, "Blocage \u00e0 l'\u00e9tape de renseignement des informations personnelles");
            this.alerteBlocageProfilRepository.saveAll((Iterable)alerteBlocageProfils);
        }
    }

    @Transactional
    public void SelectProfilStepcode1234Incomplets() {
        LocalDateTime currentDatemoins30min;
        Date dateactuellemoins30min;
        LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime currentDatesince30avril2024 = currentDate.withYear(2024).withMonth(4).withDayOfMonth(30).withHour(0).withMinute(0).withSecond(0);
        Date dateactuellesince30avril2024 = Date.from(currentDatesince30avril2024.atZone(ZoneId.of("GMT")).toInstant());
        List auteurs = this.auteurRepository.findAuteursIncomplets(dateactuellesince30avril2024, dateactuellemoins30min = Date.from((currentDatemoins30min = currentDate.minusMinutes(30L)).atZone(ZoneId.of("GMT")).toInstant()));
        if (!auteurs.isEmpty()) {
            ArrayList<AlerteBlocageProfil> blocageProfilList = new ArrayList<AlerteBlocageProfil>();
            for (Auteur a : auteurs) {
                Boolean b;
                Date dateactuelle = Date.from(currentDate.atZone(ZoneId.of("GMT")).toInstant());
                Boolean datemodifis30minbeforenow = (dateactuelle.getTime() - a.getDateModification().getTime()) / 60000L >= 30L;
                if (!datemodifis30minbeforenow.booleanValue() || !(b = Boolean.valueOf(a.getRole().equals("ami") && a.getNumwhatsapp() != null && !a.getNumwhatsapp().equals("") && a.getCode1234envoyer() == false)).booleanValue()) continue;
                AlerteBlocageProfil alerteBlocageProfil = new AlerteBlocageProfil();
                if (a.getCreerpar().equals("email")) {
                    alerteBlocageProfil.setCompte(a.getTelephone());
                } else if (a.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    alerteBlocageProfil.setCompte(a.getUsername());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                alerteBlocageProfil.setDatedecreation(sdf.format(a.getDateCreation()));
                alerteBlocageProfil.setTotalpoints(a.getTotalPointsCumules());
                alerteBlocageProfil.setTypecompte(a.getRole());
                alerteBlocageProfil.setIdcompte(a.getId());
                alerteBlocageProfil.setNamecompte(a.getName());
                alerteBlocageProfil.setObjet("Blocage \u00e0 l'\u00e9tape d'envoi du code 1234 WhatsApp");
                alerteBlocageProfil.setEstenvoyer(Boolean.valueOf(false));
                alerteBlocageProfil.setUsername(a.getUsername());
                if (a.getRole().equals("ami") && a.getNumwhatsapp() != null && !a.getNumwhatsapp().equals("") && a.getCode1234envoyer().booleanValue()) {
                    alerteBlocageProfil.setNumwhatsapp(a.getNumwhatsapp());
                }
                alerteBlocageProfil.setPays(a.getPays());
                blocageProfilList.add(alerteBlocageProfil);
            }
            if (!blocageProfilList.isEmpty()) {
                this.alerteBlocageProfilRepository.saveAll(blocageProfilList);
            }
        }
    }

    @Transactional
    public void SendProfilStepcode1234Incomplets() throws MessagingException, UnsupportedEncodingException {
        List blocageProfilList = this.alerteBlocageProfilRepository.findByEstenvoyerAndObjet(Boolean.valueOf(false), "Blocage \u00e0 l'\u00e9tape d'envoi du code 1234 WhatsApp");
        if (!blocageProfilList.isEmpty()) {
            List alerteBlocageProfils = this.mailService.sendAlertProfilIncomplets(blocageProfilList, "Blocage \u00e0 l'\u00e9tape d'envoi du code 1234 WhatsApp");
            this.alerteBlocageProfilRepository.saveAll((Iterable)alerteBlocageProfils);
        }
    }

    @Transactional
    public void SelectProfilStepCIIncomplets() {
        LocalDateTime currentDatemoins30min;
        Date dateactuellemoins30min;
        LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime currentDatesince30avril2024 = currentDate.withYear(2024).withMonth(4).withDayOfMonth(30).withHour(0).withMinute(0).withSecond(0);
        Date dateactuellesince30avril2024 = Date.from(currentDatesince30avril2024.atZone(ZoneId.of("GMT")).toInstant());
        List auteurs = this.auteurRepository.findAmisIncomplets(dateactuellesince30avril2024, dateactuellemoins30min = Date.from((currentDatemoins30min = currentDate.minusMinutes(30L)).atZone(ZoneId.of("GMT")).toInstant()));
        if (!auteurs.isEmpty()) {
            ArrayList<AlerteBlocageProfil> blocageProfilList = new ArrayList<AlerteBlocageProfil>();
            for (Auteur a : auteurs) {
                Boolean b;
                Date dateactuelle = Date.from(currentDate.atZone(ZoneId.of("GMT")).toInstant());
                Boolean datemodifis30minbeforenow = (dateactuelle.getTime() - a.getDateModification().getTime()) / 60000L >= 30L;
                if (!datemodifis30minbeforenow.booleanValue() || !(b = Boolean.valueOf(a.getCentresdinterets().isEmpty() || !a.getCentresdinterets().isEmpty() && a.getCentresdinterets().size() < 5)).booleanValue()) continue;
                AlerteBlocageProfil alerteBlocageProfil = new AlerteBlocageProfil();
                if (a.getCreerpar().equals("email")) {
                    alerteBlocageProfil.setCompte(a.getTelephone());
                } else if (a.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    alerteBlocageProfil.setCompte(a.getUsername());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                alerteBlocageProfil.setDatedecreation(sdf.format(a.getDateCreation()));
                alerteBlocageProfil.setTotalpoints(a.getTotalPointsCumules());
                alerteBlocageProfil.setTypecompte(a.getRole());
                alerteBlocageProfil.setIdcompte(a.getId());
                alerteBlocageProfil.setNamecompte(a.getName());
                alerteBlocageProfil.setObjet("Blocage \u00e0 l'\u00e9tape de s\u00e9lection des centres d'int\u00e9r\u00eats");
                alerteBlocageProfil.setEstenvoyer(Boolean.valueOf(false));
                alerteBlocageProfil.setUsername(a.getUsername());
                if (a.getRole().equals("ami") && a.getNumwhatsapp() != null && !a.getNumwhatsapp().equals("") && a.getCode1234envoyer().booleanValue()) {
                    alerteBlocageProfil.setNumwhatsapp(a.getNumwhatsapp());
                }
                alerteBlocageProfil.setPays(a.getPays());
                blocageProfilList.add(alerteBlocageProfil);
            }
            if (!blocageProfilList.isEmpty()) {
                this.alerteBlocageProfilRepository.saveAll(blocageProfilList);
            }
        }
    }

    @Transactional
    public void SendProfilStepCIIncomplets() throws MessagingException, UnsupportedEncodingException {
        List blocageProfilList = this.alerteBlocageProfilRepository.findByEstenvoyerAndObjet(Boolean.valueOf(false), "Blocage \u00e0 l'\u00e9tape de s\u00e9lection des centres d'int\u00e9r\u00eats");
        if (!blocageProfilList.isEmpty()) {
            List alerteBlocageProfils = this.mailService.sendAlertProfilIncomplets(blocageProfilList, "Blocage \u00e0 l'\u00e9tape de s\u00e9lection des centres d'int\u00e9r\u00eats");
            this.alerteBlocageProfilRepository.saveAll((Iterable)alerteBlocageProfils);
        }
    }

    @Transactional
    public void SelectProfilStepMonetisationnullIncomplets() {
        LocalDateTime currentDatemoins30min;
        Date dateactuellemoins30min;
        LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime currentDatesince30avril2024 = currentDate.withYear(2024).withMonth(4).withDayOfMonth(30).withHour(0).withMinute(0).withSecond(0);
        Date dateactuellesince30avril2024 = Date.from(currentDatesince30avril2024.atZone(ZoneId.of("GMT")).toInstant());
        List auteurs = this.auteurRepository.findAuteursmonetisationIncomplets(dateactuellesince30avril2024, dateactuellemoins30min = Date.from((currentDatemoins30min = currentDate.minusMinutes(30L)).atZone(ZoneId.of("GMT")).toInstant()));
        if (!auteurs.isEmpty()) {
            ArrayList<AlerteBlocageProfil> blocageProfilList = new ArrayList<AlerteBlocageProfil>();
            for (Auteur a : auteurs) {
                Date dateactuelle = Date.from(currentDate.atZone(ZoneId.of("GMT")).toInstant());
                Boolean datemodifis30minbeforenow = (dateactuelle.getTime() - a.getDateModification().getTime()) / 60000L >= 30L;
                if (!datemodifis30minbeforenow.booleanValue()) continue;
                AlerteBlocageProfil alerteBlocageProfil = new AlerteBlocageProfil();
                if (a.getCreerpar().equals("email")) {
                    alerteBlocageProfil.setCompte(a.getTelephone());
                } else if (a.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    alerteBlocageProfil.setCompte(a.getUsername());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                alerteBlocageProfil.setDatedecreation(sdf.format(a.getDateCreation()));
                alerteBlocageProfil.setTotalpoints(a.getTotalPointsCumules());
                alerteBlocageProfil.setTypecompte(a.getRole());
                alerteBlocageProfil.setIdcompte(a.getId());
                alerteBlocageProfil.setNamecompte(a.getName());
                alerteBlocageProfil.setObjet("Blocage \u00e0 l'\u00e9tape de choix de la mon\u00e9tisation");
                alerteBlocageProfil.setEstenvoyer(Boolean.valueOf(false));
                alerteBlocageProfil.setUsername(a.getUsername());
                if (a.getRole().equals("ami") && a.getNumwhatsapp() != null && !a.getNumwhatsapp().equals("") && a.getCode1234envoyer().booleanValue()) {
                    alerteBlocageProfil.setNumwhatsapp(a.getNumwhatsapp());
                }
                alerteBlocageProfil.setPays(a.getPays());
                blocageProfilList.add(alerteBlocageProfil);
            }
            if (!blocageProfilList.isEmpty()) {
                this.alerteBlocageProfilRepository.saveAll(blocageProfilList);
            }
        }
    }

    @Transactional
    public void SendProfilStepMonetisationnullIncomplets() throws MessagingException, UnsupportedEncodingException {
        List blocageProfilList = this.alerteBlocageProfilRepository.findByEstenvoyerAndObjet(Boolean.valueOf(false), "Blocage \u00e0 l'\u00e9tape de choix de la mon\u00e9tisation");
        if (!blocageProfilList.isEmpty()) {
            List alerteBlocageProfils = this.mailService.sendAlertProfilIncomplets(blocageProfilList, "Blocage \u00e0 l'\u00e9tape de choix de la mon\u00e9tisation");
            this.alerteBlocageProfilRepository.saveAll((Iterable)alerteBlocageProfils);
        }
    }

    @Transactional
    public void SelectProfilStepModePaiementIncomplets() {
        LocalDateTime currentDatemoins30min;
        Date dateactuellemoins30min;
        LocalDateTime currentDate = LocalDateTime.now(ZoneId.of("GMT"));
        LocalDateTime currentDatesince30avril2024 = currentDate.withYear(2024).withMonth(4).withDayOfMonth(30).withHour(0).withMinute(0).withSecond(0);
        Date dateactuellesince30avril2024 = Date.from(currentDatesince30avril2024.atZone(ZoneId.of("GMT")).toInstant());
        List auteurs = this.auteurRepository.findAuteursmonetisationOuiIncomplets(dateactuellesince30avril2024, dateactuellemoins30min = Date.from((currentDatemoins30min = currentDate.minusMinutes(30L)).atZone(ZoneId.of("GMT")).toInstant()));
        if (!auteurs.isEmpty()) {
            ArrayList<AlerteBlocageProfil> blocageProfilList = new ArrayList<AlerteBlocageProfil>();
            for (Auteur a : auteurs) {
                Date dateactuelle = Date.from(currentDate.atZone(ZoneId.of("GMT")).toInstant());
                Boolean datemodifis30minbeforenow = (dateactuelle.getTime() - a.getDateModification().getTime()) / 60000L >= 30L;
                if (!datemodifis30minbeforenow.booleanValue()) continue;
                ModePaiement modePaiement = this.modePaiementRepository.findByAuteurID(a.getId());
                if (modePaiement != null) {
                    Boolean modepaiementcorrect = modePaiement.getMode().equals("Wallet") && modePaiement.getOperateur() != null && modePaiement.getNumero() != null || modePaiement.getMode().equals("Western Union") && modePaiement.getNomb() != null && modePaiement.getPrenomb() != null && modePaiement.getPaysdest() != null || modePaiement.getMode().equals("Virement bancaire") && modePaiement.getNumcompte() != null && modePaiement.getCodebanque() != null && modePaiement.getCodeguichet() != null && modePaiement.getDomiciliation() != null && modePaiement.getNomtitucompte() != null && modePaiement.getRib() != null;
                    if (modepaiementcorrect.booleanValue()) continue;
                    AlerteBlocageProfil alerteBlocageProfil = new AlerteBlocageProfil();
                    alerteBlocageProfil.setNamecompte(a.getName());
                    if (a.getCreerpar().equals("email")) {
                        alerteBlocageProfil.setCompte(a.getTelephone());
                    } else if (a.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                        alerteBlocageProfil.setCompte(a.getUsername());
                    }
                    SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                    alerteBlocageProfil.setDatedecreation(sdf.format(a.getDateCreation()));
                    alerteBlocageProfil.setTotalpoints(a.getTotalPointsCumules());
                    alerteBlocageProfil.setTypecompte(a.getRole());
                    alerteBlocageProfil.setIdcompte(a.getId());
                    alerteBlocageProfil.setObjet("Blocage \u00e0 l'\u00e9tape du mode de paiement");
                    alerteBlocageProfil.setEstenvoyer(Boolean.valueOf(false));
                    alerteBlocageProfil.setUsername(a.getUsername());
                    if (a.getRole().equals("ami") && a.getNumwhatsapp() != null && !a.getNumwhatsapp().equals("") && a.getCode1234envoyer().booleanValue()) {
                        alerteBlocageProfil.setNumwhatsapp(a.getNumwhatsapp());
                    }
                    alerteBlocageProfil.setPays(a.getPays());
                    blocageProfilList.add(alerteBlocageProfil);
                    continue;
                }
                if (modePaiement != null) continue;
                AlerteBlocageProfil alerteBlocageProfil = new AlerteBlocageProfil();
                alerteBlocageProfil.setNamecompte(a.getName());
                if (a.getCreerpar().equals("email")) {
                    alerteBlocageProfil.setCompte(a.getTelephone());
                } else if (a.getCreerpar().equals("t\u00e9l\u00e9phone")) {
                    alerteBlocageProfil.setCompte(a.getUsername());
                }
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                alerteBlocageProfil.setDatedecreation(sdf.format(a.getDateCreation()));
                alerteBlocageProfil.setTotalpoints(a.getTotalPointsCumules());
                alerteBlocageProfil.setTypecompte(a.getRole());
                alerteBlocageProfil.setIdcompte(a.getId());
                alerteBlocageProfil.setUsername(a.getUsername());
                if (a.getRole().equals("ami") && a.getNumwhatsapp() != null && !a.getNumwhatsapp().equals("") && a.getCode1234envoyer().booleanValue()) {
                    alerteBlocageProfil.setNumwhatsapp(a.getNumwhatsapp());
                }
                alerteBlocageProfil.setPays(a.getPays());
                alerteBlocageProfil.setObjet("Blocage \u00e0 l'\u00e9tape du mode de paiement");
                alerteBlocageProfil.setEstenvoyer(Boolean.valueOf(false));
                blocageProfilList.add(alerteBlocageProfil);
            }
            if (!blocageProfilList.isEmpty()) {
                this.alerteBlocageProfilRepository.saveAll(blocageProfilList);
            }
        }
    }

    @Transactional
    public void SendProfilStepModePaiementIncomplets() throws MessagingException, UnsupportedEncodingException {
        List blocageProfilList = this.alerteBlocageProfilRepository.findByEstenvoyerAndObjet(Boolean.valueOf(false), "Blocage \u00e0 l'\u00e9tape du mode de paiement");
        if (!blocageProfilList.isEmpty()) {
            List alerteBlocageProfils = this.mailService.sendAlertProfilIncomplets(blocageProfilList, "Blocage \u00e0 l'\u00e9tape du mode de paiement");
            this.alerteBlocageProfilRepository.saveAll((Iterable)alerteBlocageProfils);
        }
    }

    @Transactional
    public VerifCompteDTO verifierComptewhatsapp(String numwhatsapp) {
        Auteur auteur = this.auteurRepository.findTop1ByNumwhatsappAndBloquerAndRole(numwhatsapp, Boolean.valueOf(false), "ami");
        VerifCompteDTO verifCompteDTO = new VerifCompteDTO();
        verifCompteDTO.setNum(numwhatsapp);
        if (auteur != null) {
            verifCompteDTO.setCompteexiste("oui");
            if (auteur.getCode1234envoyer().booleanValue()) {
                verifCompteDTO.setCodeenvoyer("oui");
            } else {
                verifCompteDTO.setCodeenvoyer("non");
            }
        } else {
            verifCompteDTO.setCompteexiste("non");
            verifCompteDTO.setCodeenvoyer("non");
        }
        return verifCompteDTO;
    }

    public String generateRandomString(int length) {
        String SYMBOLS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?";
        SecureRandom random = new SecureRandom();
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomIndex = random.nextInt("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".length());
            char randomChar = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#$%^&*()_+-=[]{}|;:,.<>?".charAt(randomIndex);
            sb.append(randomChar);
        }
        return sb.toString();
    }

    public void AffecterWPid(SubdomainsPaysEnum subdomain, Auteur auteur, Long id) {
        switch (1.$SwitchMap$com$notrecontinent$webapi$enumeration$SubdomainsPaysEnum[subdomain.ordinal()]) {
            case 1: {
                auteur.setWordpressID(id);
                break;
            }
            case 2: {
                auteur.setCaWordpressID(id);
                break;
            }
            case 3: {
                auteur.setBfWordpressID(id);
                break;
            }
            case 4: {
                auteur.setBjWordpressID(id);
                break;
            }
            case 5: {
                auteur.setCdWordpressID(id);
                break;
            }
            case 6: {
                auteur.setCgWordpressID(id);
                break;
            }
            case 7: {
                auteur.setCiWordpressID(id);
                break;
            }
            case 8: {
                auteur.setCmWordpressID(id);
                break;
            }
            case 9: {
                auteur.setFrWordpressID(id);
                break;
            }
            case 10: {
                auteur.setGaWordpressID(id);
                break;
            }
            case 11: {
                auteur.setGnWordpressID(id);
                break;
            }
            case 12: {
                auteur.setMgWordpressID(id);
                break;
            }
            case 13: {
                auteur.setMlWordpressID(id);
                break;
            }
            case 14: {
                auteur.setMrWordpressID(id);
                break;
            }
            case 15: {
                auteur.setNeWordpressID(id);
                break;
            }
            case 16: {
                auteur.setTgWordpressID(id);
                break;
            }
        }
    }

    public void ModifierCompteWP(SubdomainsPaysEnum subdomain, Auteur auteur, HttpEntity<CompteWP> requestEntity) {
        switch (1.$SwitchMap$com$notrecontinent$webapi$enumeration$SubdomainsPaysEnum[subdomain.ordinal()]) {
            case 1: {
                if (auteur.getWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 2: {
                if (auteur.getCaWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCaWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 3: {
                if (auteur.getBfWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getBfWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 4: {
                if (auteur.getBjWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getBjWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 5: {
                if (auteur.getCdWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCdWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 6: {
                if (auteur.getCgWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCgWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 7: {
                if (auteur.getCiWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCiWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 8: {
                if (auteur.getCmWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getCmWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 9: {
                if (auteur.getFrWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getFrWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 10: {
                if (auteur.getGaWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getGaWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 11: {
                if (auteur.getGnWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getGnWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 12: {
                if (auteur.getMgWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getMgWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 13: {
                if (auteur.getMlWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getMlWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 14: {
                if (auteur.getMrWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getMrWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 15: {
                if (auteur.getNeWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getNeWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
            case 16: {
                if (auteur.getTgWordpressID() == null) break;
                String response = (String)this.restTemplate.exchange(subdomain.getSubdomain() + "/wp-json/wp/v2/users/" + auteur.getTgWordpressID(), HttpMethod.PUT, requestEntity, String.class, new Object[0]).getBody();
                break;
            }
        }
    }
}

