/*
 * Decompiled with CFR 0.152.
 */
package com.notrecontinent.webapi.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.notrecontinent.webapi.LesDTOs.ArticleStatistiqueCC;
import com.notrecontinent.webapi.dto.StatcounterPageStats;
import com.notrecontinent.webapi.entities.Statistique;
import com.notrecontinent.webapi.services.StatistiquesService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/momar"})
@CrossOrigin(origins={"https://hostspeaky.com", "http://localhost:4200"}, allowedHeaders={"*"}, allowCredentials="true", methods={RequestMethod.GET, RequestMethod.POST, RequestMethod.DELETE, RequestMethod.PUT, RequestMethod.OPTIONS})
public class StatistiquesController {
    @Autowired
    private StatistiquesService statistiquesService;

    @GetMapping(value={"/Statistiques/test"})
    public List<Statistique> getStatcounterStatsForTests() throws JsonProcessingException {
        return this.statistiquesService.getStatcounterStatsForTests();
    }

    @GetMapping(value={"/Statistiques/{auteurID}"})
    public ResponseEntity<List<ArticleStatistiqueCC>> getAuteurStatistiques(@PathVariable(value="auteurID") Long auteurID) throws IOException {
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("R\u00e9cup\u00e9ration des statistiques par leur contributeur");
        System.out.println("-------------------------------------------------------------------------------");
        return this.statistiquesService.getStatistiquesByAuteurID(auteurID);
    }

    @GetMapping(value={"/Statistiques/all"})
    public List<StatcounterPageStats> getAllStatistiques() throws JsonProcessingException {
        return this.statistiquesService.getAllStatistiques();
    }
}

